/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.groups;

import org.signal.client.internal.Native;
import org.whispersystems.libsignal.SignalProtocolAddress;

public class SenderKeyName {
    private long handle;

    public SenderKeyName(String groupId, SignalProtocolAddress sender) {
        this.handle = Native.SenderKeyName_New(groupId, sender.getName(), sender.getDeviceId());
    }

    public SenderKeyName(String groupId, String senderName, int senderDeviceId) {
        this.handle = Native.SenderKeyName_New(groupId, senderName, senderDeviceId);
    }

    protected void finalize() {
        Native.SenderKeyName_Destroy(this.handle);
    }

    public String getGroupId() {
        return Native.SenderKeyName_GetGroupId(this.handle);
    }

    public SignalProtocolAddress getSender() {
        return new SignalProtocolAddress(Native.SenderKeyName_GetSenderName(this.handle), Native.SenderKeyName_GetSenderDeviceId(this.handle));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SenderKeyName)) {
            return false;
        }
        SenderKeyName that = (SenderKeyName)other;
        return this.getGroupId().equals(that.getGroupId()) && this.getSender().equals(that.getSender());
    }

    public int hashCode() {
        return this.getGroupId().hashCode() ^ this.getSender().hashCode();
    }

    public long nativeHandle() {
        return this.handle;
    }
}

