/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state;

import org.signal.client.internal.Native;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;

public class PreKeyBundle {
    private long handle;

    protected void finalize() {
        Native.PreKeyBundle_Destroy(this.handle);
    }

    public PreKeyBundle(int registrationId, int deviceId, int preKeyId, ECPublicKey preKeyPublic, int signedPreKeyId, ECPublicKey signedPreKeyPublic, byte[] signedPreKeySignature, IdentityKey identityKey) {
        long preKeyPublicHandle = 0L;
        if (preKeyPublic != null) {
            preKeyPublicHandle = preKeyPublic.nativeHandle();
        }
        this.handle = Native.PreKeyBundle_New(registrationId, deviceId, preKeyId, preKeyPublicHandle, signedPreKeyId, signedPreKeyPublic.nativeHandle(), signedPreKeySignature, identityKey.getPublicKey().nativeHandle());
    }

    public int getDeviceId() {
        return Native.PreKeyBundle_GetDeviceId(this.handle);
    }

    public int getPreKeyId() {
        return Native.PreKeyBundle_GetPreKeyId(this.handle);
    }

    public ECPublicKey getPreKey() {
        long handle = Native.PreKeyBundle_GetPreKeyPublic(this.handle);
        if (handle != 0L) {
            return new ECPublicKey(handle);
        }
        return null;
    }

    public int getSignedPreKeyId() {
        return Native.PreKeyBundle_GetSignedPreKeyId(this.handle);
    }

    public ECPublicKey getSignedPreKey() {
        return new ECPublicKey(Native.PreKeyBundle_GetSignedPreKeyPublic(this.handle));
    }

    public byte[] getSignedPreKeySignature() {
        return Native.PreKeyBundle_GetSignedPreKeySignature(this.handle);
    }

    public IdentityKey getIdentityKey() {
        return new IdentityKey(new ECPublicKey(Native.PreKeyBundle_GetIdentityKey(this.handle)));
    }

    public int getRegistrationId() {
        return Native.PreKeyBundle_GetRegistrationId(this.handle);
    }

    public long nativeHandle() {
        return this.handle;
    }
}

