/*
 * Decompiled with CFR 0.152.
 */
package org.signal.client.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.whispersystems.libsignal.groups.state.SenderKeyStore;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignedPreKeyStore;

public final class Native {
    private static void copyToTempFileAndLoad(InputStream in, String extension) throws IOException {
        File tempFile = Files.createTempFile("resource", extension, new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        System.load(tempFile.getAbsolutePath());
    }

    private static void loadLibrary() {
        try {
            String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            boolean isMacOs = osName.startsWith("mac os");
            String extension = isMacOs ? ".dylib" : ".so";
            try (InputStream in = Native.class.getResourceAsStream("/libsignal_jni" + extension);){
                if (in != null) {
                    Native.copyToTempFileAndLoad(in, extension);
                } else {
                    System.loadLibrary("signal_jni");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Native() {
    }

    public static native String DisplayableFingerprint_Format(byte[] var0, byte[] var1);

    public static native byte[] ECPrivateKey_Agree(long var0, long var2);

    public static native long ECPrivateKey_Deserialize(byte[] var0);

    public static native void ECPrivateKey_Destroy(long var0);

    public static native long ECPrivateKey_Generate();

    public static native long ECPrivateKey_GetPublicKey(long var0);

    public static native byte[] ECPrivateKey_Serialize(long var0);

    public static native byte[] ECPrivateKey_Sign(long var0, byte[] var2);

    public static native int ECPublicKey_Compare(long var0, long var2);

    public static native long ECPublicKey_Deserialize(byte[] var0, int var1);

    public static native void ECPublicKey_Destroy(long var0);

    public static native byte[] ECPublicKey_GetPublicKeyBytes(long var0);

    public static native byte[] ECPublicKey_Serialize(long var0);

    public static native boolean ECPublicKey_Verify(long var0, byte[] var2, byte[] var3);

    public static native byte[] GroupCipher_DecryptMessage(long var0, byte[] var2, SenderKeyStore var3);

    public static native byte[] GroupCipher_EncryptMessage(long var0, byte[] var2, SenderKeyStore var3);

    public static native long GroupSessionBuilder_CreateSenderKeyDistributionMessage(long var0, SenderKeyStore var2);

    public static native void GroupSessionBuilder_ProcessSenderKeyDistributionMessage(long var0, long var2, SenderKeyStore var4);

    public static native byte[] HKDF_DeriveSecrets(int var0, byte[] var1, byte[] var2, byte[] var3, int var4);

    public static native byte[] IdentityKeyPair_Serialize(long var0, long var2);

    public static native void NumericFingerprintGenerator_Destroy(long var0);

    public static native String NumericFingerprintGenerator_GetDisplayString(long var0);

    public static native byte[] NumericFingerprintGenerator_GetScannableEncoding(long var0);

    public static native long NumericFingerprintGenerator_New(int var0, int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    public static native void PreKeyBundle_Destroy(long var0);

    public static native int PreKeyBundle_GetDeviceId(long var0);

    public static native long PreKeyBundle_GetIdentityKey(long var0);

    public static native int PreKeyBundle_GetPreKeyId(long var0);

    public static native long PreKeyBundle_GetPreKeyPublic(long var0);

    public static native int PreKeyBundle_GetRegistrationId(long var0);

    public static native int PreKeyBundle_GetSignedPreKeyId(long var0);

    public static native long PreKeyBundle_GetSignedPreKeyPublic(long var0);

    public static native byte[] PreKeyBundle_GetSignedPreKeySignature(long var0);

    public static native long PreKeyBundle_New(int var0, int var1, int var2, long var3, int var5, long var6, byte[] var8, long var9);

    public static native long PreKeyRecord_Deserialize(byte[] var0);

    public static native void PreKeyRecord_Destroy(long var0);

    public static native int PreKeyRecord_GetId(long var0);

    public static native long PreKeyRecord_GetPrivateKey(long var0);

    public static native long PreKeyRecord_GetPublicKey(long var0);

    public static native byte[] PreKeyRecord_GetSerialized(long var0);

    public static native long PreKeyRecord_New(int var0, long var1, long var3);

    public static native long PreKeySignalMessage_Deserialize(byte[] var0);

    public static native void PreKeySignalMessage_Destroy(long var0);

    public static native byte[] PreKeySignalMessage_GetBaseKey(long var0);

    public static native byte[] PreKeySignalMessage_GetIdentityKey(long var0);

    public static native int PreKeySignalMessage_GetPreKeyId(long var0);

    public static native int PreKeySignalMessage_GetRegistrationId(long var0);

    public static native byte[] PreKeySignalMessage_GetSerialized(long var0);

    public static native byte[] PreKeySignalMessage_GetSignalMessage(long var0);

    public static native int PreKeySignalMessage_GetSignedPreKeyId(long var0);

    public static native int PreKeySignalMessage_GetVersion(long var0);

    public static native long PreKeySignalMessage_New(int var0, int var1, int var2, int var3, long var4, long var6, long var8);

    public static native void ProtocolAddress_Destroy(long var0);

    public static native int ProtocolAddress_DeviceId(long var0);

    public static native String ProtocolAddress_Name(long var0);

    public static native long ProtocolAddress_New(String var0, int var1);

    public static native boolean ScannableFingerprint_Compare(byte[] var0, byte[] var1);

    public static native long SenderKeyDistributionMessage_Deserialize(byte[] var0);

    public static native void SenderKeyDistributionMessage_Destroy(long var0);

    public static native byte[] SenderKeyDistributionMessage_GetChainKey(long var0);

    public static native int SenderKeyDistributionMessage_GetId(long var0);

    public static native int SenderKeyDistributionMessage_GetIteration(long var0);

    public static native byte[] SenderKeyDistributionMessage_GetSerialized(long var0);

    public static native byte[] SenderKeyDistributionMessage_GetSignatureKey(long var0);

    public static native long SenderKeyDistributionMessage_New(int var0, int var1, byte[] var2, long var3);

    public static native long SenderKeyMessage_Deserialize(byte[] var0);

    public static native void SenderKeyMessage_Destroy(long var0);

    public static native byte[] SenderKeyMessage_GetCipherText(long var0);

    public static native int SenderKeyMessage_GetIteration(long var0);

    public static native int SenderKeyMessage_GetKeyId(long var0);

    public static native byte[] SenderKeyMessage_GetSerialized(long var0);

    public static native long SenderKeyMessage_New(int var0, int var1, byte[] var2, long var3);

    public static native boolean SenderKeyMessage_VerifySignature(long var0, long var2);

    public static native void SenderKeyName_Destroy(long var0);

    public static native String SenderKeyName_GetGroupId(long var0);

    public static native int SenderKeyName_GetSenderDeviceId(long var0);

    public static native String SenderKeyName_GetSenderName(long var0);

    public static native long SenderKeyName_New(String var0, String var1, int var2);

    public static native long SenderKeyRecord_Deserialize(byte[] var0);

    public static native void SenderKeyRecord_Destroy(long var0);

    public static native byte[] SenderKeyRecord_GetSerialized(long var0);

    public static native long SenderKeyRecord_New();

    public static native void SessionBuilder_ProcessPreKeyBundle(long var0, long var2, SessionStore var4, IdentityKeyStore var5);

    public static native byte[] SessionCipher_DecryptPreKeySignalMessage(long var0, long var2, SessionStore var4, IdentityKeyStore var5, PreKeyStore var6, SignedPreKeyStore var7);

    public static native byte[] SessionCipher_DecryptSignalMessage(long var0, long var2, SessionStore var4, IdentityKeyStore var5);

    public static native CiphertextMessage SessionCipher_EncryptMessage(byte[] var0, long var1, SessionStore var3, IdentityKeyStore var4);

    public static native byte[] SessionState_InitializeAliceSession(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static native byte[] SessionState_InitializeBobSession(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    public static native long SignalMessage_Deserialize(byte[] var0);

    public static native void SignalMessage_Destroy(long var0);

    public static native byte[] SignalMessage_GetBody(long var0);

    public static native int SignalMessage_GetCounter(long var0);

    public static native int SignalMessage_GetMessageVersion(long var0);

    public static native byte[] SignalMessage_GetSenderRatchetKey(long var0);

    public static native byte[] SignalMessage_GetSerialized(long var0);

    public static native long SignalMessage_New(int var0, byte[] var1, long var2, int var4, int var5, byte[] var6, long var7, long var9);

    public static native boolean SignalMessage_VerifyMac(long var0, long var2, long var4, byte[] var6);

    public static native long SignedPreKeyRecord_Deserialize(byte[] var0);

    public static native void SignedPreKeyRecord_Destroy(long var0);

    public static native int SignedPreKeyRecord_GetId(long var0);

    public static native long SignedPreKeyRecord_GetPrivateKey(long var0);

    public static native long SignedPreKeyRecord_GetPublicKey(long var0);

    public static native byte[] SignedPreKeyRecord_GetSerialized(long var0);

    public static native byte[] SignedPreKeyRecord_GetSignature(long var0);

    public static native long SignedPreKeyRecord_GetTimestamp(long var0);

    public static native long SignedPreKeyRecord_New(int var0, long var1, long var3, long var5, byte[] var7);

    static {
        Native.loadLibrary();
    }
}

