/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import com.google.protobuf.InvalidProtocolBufferException;
import org.signal.libsignal.metadata.SignalProtos;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;

public class ServerCertificate {
    private final int keyId;
    private final ECPublicKey key;
    private final byte[] serialized;
    private final byte[] certificate;
    private final byte[] signature;

    public ServerCertificate(byte[] serialized) throws InvalidCertificateException {
        try {
            SignalProtos.ServerCertificate wrapper = SignalProtos.ServerCertificate.parseFrom(serialized);
            if (!wrapper.hasCertificate() || !wrapper.hasSignature()) {
                throw new InvalidCertificateException("Missing fields");
            }
            SignalProtos.ServerCertificate.Certificate certificate = SignalProtos.ServerCertificate.Certificate.parseFrom(wrapper.getCertificate());
            if (!certificate.hasId() || !certificate.hasKey()) {
                throw new InvalidCertificateException("Missing fields");
            }
            this.keyId = certificate.getId();
            this.key = Curve.decodePoint(certificate.getKey().toByteArray(), 0);
            this.serialized = serialized;
            this.certificate = wrapper.getCertificate().toByteArray();
            this.signature = wrapper.getSignature().toByteArray();
        }
        catch (InvalidProtocolBufferException | InvalidKeyException e) {
            throw new InvalidCertificateException((Exception)e);
        }
    }

    public int getKeyId() {
        return this.keyId;
    }

    public ECPublicKey getKey() {
        return this.key;
    }

    public byte[] getSerialized() {
        return this.serialized;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

