/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.protocol;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.signal.libsignal.metadata.InvalidMetadataMessageException;
import org.signal.libsignal.metadata.InvalidMetadataVersionException;
import org.signal.libsignal.metadata.SignalProtos;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.util.ByteUtil;

public class UnidentifiedSenderMessage {
    private static final int CIPHERTEXT_VERSION = 1;
    private final int version;
    private final ECPublicKey ephemeral;
    private final byte[] encryptedStatic;
    private final byte[] encryptedMessage;
    private final byte[] serialized;

    public UnidentifiedSenderMessage(byte[] serialized) throws InvalidMetadataMessageException, InvalidMetadataVersionException {
        try {
            this.version = ByteUtil.highBitsToInt(serialized[0]);
            if (this.version > 1) {
                throw new InvalidMetadataVersionException("Unknown version: " + this.version);
            }
            SignalProtos.UnidentifiedSenderMessage unidentifiedSenderMessage = SignalProtos.UnidentifiedSenderMessage.parseFrom(ByteString.copyFrom((byte[])serialized, (int)1, (int)(serialized.length - 1)));
            if (!(unidentifiedSenderMessage.hasEphemeralPublic() && unidentifiedSenderMessage.hasEncryptedStatic() && unidentifiedSenderMessage.hasEncryptedMessage())) {
                throw new InvalidMetadataMessageException("Missing fields");
            }
            this.ephemeral = Curve.decodePoint(unidentifiedSenderMessage.getEphemeralPublic().toByteArray(), 0);
            this.encryptedStatic = unidentifiedSenderMessage.getEncryptedStatic().toByteArray();
            this.encryptedMessage = unidentifiedSenderMessage.getEncryptedMessage().toByteArray();
            this.serialized = serialized;
        }
        catch (InvalidProtocolBufferException | InvalidKeyException e) {
            throw new InvalidMetadataMessageException((Exception)e);
        }
    }

    public UnidentifiedSenderMessage(ECPublicKey ephemeral, byte[] encryptedStatic, byte[] encryptedMessage) {
        this.version = 1;
        this.ephemeral = ephemeral;
        this.encryptedStatic = encryptedStatic;
        this.encryptedMessage = encryptedMessage;
        byte[] versionBytes = new byte[]{ByteUtil.intsToByteHighAndLow(1, 1)};
        byte[] messageBytes = ((SignalProtos.UnidentifiedSenderMessage)SignalProtos.UnidentifiedSenderMessage.newBuilder().setEncryptedMessage(ByteString.copyFrom((byte[])encryptedMessage)).setEncryptedStatic(ByteString.copyFrom((byte[])encryptedStatic)).setEphemeralPublic(ByteString.copyFrom((byte[])ephemeral.serialize())).build()).toByteArray();
        this.serialized = ByteUtil.combine(versionBytes, messageBytes);
    }

    public ECPublicKey getEphemeral() {
        return this.ephemeral;
    }

    public byte[] getEncryptedStatic() {
        return this.encryptedStatic;
    }

    public byte[] getEncryptedMessage() {
        return this.encryptedMessage;
    }

    public byte[] getSerialized() {
        return this.serialized;
    }
}

