/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal;

import org.signal.client.internal.Native;

public class SignalProtocolAddress {
    private final long handle;

    public SignalProtocolAddress(String name, int deviceId) {
        this.handle = Native.ProtocolAddress_New(name, deviceId);
    }

    protected void finalize() {
        Native.ProtocolAddress_Destroy((long)this.handle);
    }

    public String getName() {
        return Native.ProtocolAddress_Name(this.handle);
    }

    public int getDeviceId() {
        return Native.ProtocolAddress_DeviceId(this.handle);
    }

    public String toString() {
        return this.getName() + ":" + this.getDeviceId();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SignalProtocolAddress)) {
            return false;
        }
        SignalProtocolAddress that = (SignalProtocolAddress)other;
        return this.getName().equals(that.getName()) && this.getDeviceId() == that.getDeviceId();
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getDeviceId();
    }

    public long nativeHandle() {
        return this.handle;
    }
}

