/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.fingerprint;

import org.signal.client.internal.Native;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.fingerprint.DisplayableFingerprint;
import org.whispersystems.libsignal.fingerprint.Fingerprint;
import org.whispersystems.libsignal.fingerprint.FingerprintGenerator;
import org.whispersystems.libsignal.fingerprint.ScannableFingerprint;

public class NumericFingerprintGenerator
implements FingerprintGenerator {
    private final int iterations;

    public NumericFingerprintGenerator(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public Fingerprint createFor(int version, byte[] localStableIdentifier, IdentityKey localIdentityKey, byte[] remoteStableIdentifier, IdentityKey remoteIdentityKey) {
        long handle = Native.NumericFingerprintGenerator_New(this.iterations, version, localStableIdentifier, localIdentityKey.serialize(), remoteStableIdentifier, remoteIdentityKey.serialize());
        DisplayableFingerprint displayableFingerprint = new DisplayableFingerprint(Native.NumericFingerprintGenerator_GetDisplayString(handle));
        ScannableFingerprint scannableFingerprint = new ScannableFingerprint(Native.NumericFingerprintGenerator_GetScannableEncoding(handle));
        Native.NumericFingerprintGenerator_Destroy(handle);
        return new Fingerprint(displayableFingerprint, scannableFingerprint);
    }
}

