/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.kdf;

import org.signal.client.internal.Native;
import org.whispersystems.libsignal.kdf.HKDFv2;
import org.whispersystems.libsignal.kdf.HKDFv3;

public abstract class HKDF {
    private static final int HASH_OUTPUT_SIZE = 32;

    public static HKDF createFor(int messageVersion) {
        switch (messageVersion) {
            case 2: {
                return new HKDFv2();
            }
            case 3: {
                return new HKDFv3();
            }
        }
        throw new AssertionError((Object)("Unknown version: " + messageVersion));
    }

    public byte[] deriveSecrets(byte[] inputKeyMaterial, byte[] info, int outputLength) {
        return Native.HKDF_DeriveSecrets(this.getVersion(), inputKeyMaterial, null, info, outputLength);
    }

    public byte[] deriveSecrets(byte[] inputKeyMaterial, byte[] salt, byte[] info, int outputLength) {
        return Native.HKDF_DeriveSecrets(this.getVersion(), inputKeyMaterial, salt, info, outputLength);
    }

    protected abstract int getVersion();
}

