/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal;

import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.util.Hex;

public class IdentityKey {
    private final ECPublicKey publicKey;

    public IdentityKey(ECPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public IdentityKey(byte[] bytes, int offset) throws InvalidKeyException {
        this.publicKey = Curve.decodePoint(bytes, offset);
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] serialize() {
        return this.publicKey.serialize();
    }

    public String getFingerprint() {
        return Hex.toString(this.publicKey.serialize());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof IdentityKey)) {
            return false;
        }
        return this.publicKey.equals(((IdentityKey)other).getPublicKey());
    }

    public int hashCode() {
        return this.publicKey.hashCode();
    }
}

