/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.state.StorageProtos;

public class IdentityKeyPair {
    private final IdentityKey publicKey;
    private final ECPrivateKey privateKey;

    public IdentityKeyPair(IdentityKey publicKey, ECPrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public IdentityKeyPair(byte[] serialized) throws InvalidKeyException {
        try {
            StorageProtos.IdentityKeyPairStructure structure = StorageProtos.IdentityKeyPairStructure.parseFrom(serialized);
            this.publicKey = new IdentityKey(structure.getPublicKey().toByteArray(), 0);
            this.privateKey = Curve.decodePrivatePoint(structure.getPrivateKey().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidKeyException(e);
        }
    }

    public IdentityKey getPublicKey() {
        return this.publicKey;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public byte[] serialize() {
        return ((StorageProtos.IdentityKeyPairStructure)StorageProtos.IdentityKeyPairStructure.newBuilder().setPublicKey(ByteString.copyFrom((byte[])this.publicKey.serialize())).setPrivateKey(ByteString.copyFrom((byte[])this.privateKey.serialize())).build()).toByteArray();
    }
}

