/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.fingerprint;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.fingerprint.DisplayableFingerprint;
import org.whispersystems.libsignal.fingerprint.Fingerprint;
import org.whispersystems.libsignal.fingerprint.FingerprintGenerator;
import org.whispersystems.libsignal.fingerprint.ScannableFingerprint;
import org.whispersystems.libsignal.util.ByteUtil;
import org.whispersystems.libsignal.util.IdentityKeyComparator;

public class NumericFingerprintGenerator
implements FingerprintGenerator {
    private static final int FINGERPRINT_VERSION = 0;
    private final int iterations;

    public NumericFingerprintGenerator(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public Fingerprint createFor(int version, byte[] localStableIdentifier, final IdentityKey localIdentityKey, byte[] remoteStableIdentifier, final IdentityKey remoteIdentityKey) {
        return this.createFor(version, localStableIdentifier, (List<IdentityKey>)new LinkedList<IdentityKey>(){
            {
                this.add(localIdentityKey);
            }
        }, remoteStableIdentifier, (List<IdentityKey>)new LinkedList<IdentityKey>(){
            {
                this.add(remoteIdentityKey);
            }
        });
    }

    @Override
    public Fingerprint createFor(int version, byte[] localStableIdentifier, List<IdentityKey> localIdentityKeys, byte[] remoteStableIdentifier, List<IdentityKey> remoteIdentityKeys) {
        byte[] localFingerprint = this.getFingerprint(this.iterations, localStableIdentifier, localIdentityKeys);
        byte[] remoteFingerprint = this.getFingerprint(this.iterations, remoteStableIdentifier, remoteIdentityKeys);
        DisplayableFingerprint displayableFingerprint = new DisplayableFingerprint(localFingerprint, remoteFingerprint);
        ScannableFingerprint scannableFingerprint = new ScannableFingerprint(version, localFingerprint, remoteFingerprint);
        return new Fingerprint(displayableFingerprint, scannableFingerprint);
    }

    private byte[] getFingerprint(int iterations, byte[] stableIdentifier, List<IdentityKey> unsortedIdentityKeys) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] publicKey = this.getLogicalKeyBytes(unsortedIdentityKeys);
            byte[] hash = ByteUtil.combine(ByteUtil.shortToByteArray(0), publicKey, stableIdentifier);
            for (int i = 0; i < iterations; ++i) {
                digest.update(hash);
                hash = digest.digest(publicKey);
            }
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] getLogicalKeyBytes(List<IdentityKey> identityKeys) {
        ArrayList<IdentityKey> sortedIdentityKeys = new ArrayList<IdentityKey>(identityKeys);
        Collections.sort(sortedIdentityKeys, new IdentityKeyComparator());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (IdentityKey identityKey : sortedIdentityKeys) {
            byte[] publicKeyBytes = identityKey.getPublicKey().serialize();
            baos.write(publicKeyBytes, 0, publicKeyBytes.length);
        }
        return baos.toByteArray();
    }
}

