/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.groups.state;

import java.io.IOException;
import java.util.LinkedList;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.groups.state.SenderKeyState;
import org.whispersystems.libsignal.state.StorageProtos;

public class SenderKeyRecord {
    private static final int MAX_STATES = 5;
    private LinkedList<SenderKeyState> senderKeyStates = new LinkedList();

    public SenderKeyRecord() {
    }

    public SenderKeyRecord(byte[] serialized) throws IOException {
        StorageProtos.SenderKeyRecordStructure senderKeyRecordStructure = StorageProtos.SenderKeyRecordStructure.parseFrom(serialized);
        for (StorageProtos.SenderKeyStateStructure structure : senderKeyRecordStructure.getSenderKeyStatesList()) {
            this.senderKeyStates.add(new SenderKeyState(structure));
        }
    }

    public boolean isEmpty() {
        return this.senderKeyStates.isEmpty();
    }

    public SenderKeyState getSenderKeyState() throws InvalidKeyIdException {
        if (!this.senderKeyStates.isEmpty()) {
            return this.senderKeyStates.get(0);
        }
        throw new InvalidKeyIdException("No key state in record!");
    }

    public SenderKeyState getSenderKeyState(int keyId) throws InvalidKeyIdException {
        for (SenderKeyState state : this.senderKeyStates) {
            if (state.getKeyId() != keyId) continue;
            return state;
        }
        throw new InvalidKeyIdException("No keys for: " + keyId);
    }

    public void addSenderKeyState(int id, int iteration, byte[] chainKey, ECPublicKey signatureKey) {
        this.senderKeyStates.addFirst(new SenderKeyState(id, iteration, chainKey, signatureKey));
        if (this.senderKeyStates.size() > 5) {
            this.senderKeyStates.removeLast();
        }
    }

    public void setSenderKeyState(int id, int iteration, byte[] chainKey, ECKeyPair signatureKey) {
        this.senderKeyStates.clear();
        this.senderKeyStates.add(new SenderKeyState(id, iteration, chainKey, signatureKey));
    }

    public byte[] serialize() {
        StorageProtos.SenderKeyRecordStructure.Builder recordStructure = StorageProtos.SenderKeyRecordStructure.newBuilder();
        for (SenderKeyState senderKeyState : this.senderKeyStates) {
            recordStructure.addSenderKeyStates(senderKeyState.getStructure());
        }
        return ((StorageProtos.SenderKeyRecordStructure)recordStructure.build()).toByteArray();
    }
}

