/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.groups.state;

import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.LinkedList;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.groups.ratchet.SenderChainKey;
import org.whispersystems.libsignal.groups.ratchet.SenderMessageKey;
import org.whispersystems.libsignal.state.StorageProtos;
import org.whispersystems.libsignal.util.guava.Optional;

public class SenderKeyState {
    private static final int MAX_MESSAGE_KEYS = 2000;
    private StorageProtos.SenderKeyStateStructure senderKeyStateStructure;

    public SenderKeyState(int id, int iteration, byte[] chainKey, ECPublicKey signatureKey) {
        this(id, iteration, chainKey, signatureKey, Optional.absent());
    }

    public SenderKeyState(int id, int iteration, byte[] chainKey, ECKeyPair signatureKey) {
        this(id, iteration, chainKey, signatureKey.getPublicKey(), Optional.of(signatureKey.getPrivateKey()));
    }

    private SenderKeyState(int id, int iteration, byte[] chainKey, ECPublicKey signatureKeyPublic, Optional<ECPrivateKey> signatureKeyPrivate) {
        StorageProtos.SenderKeyStateStructure.SenderChainKey senderChainKeyStructure = (StorageProtos.SenderKeyStateStructure.SenderChainKey)StorageProtos.SenderKeyStateStructure.SenderChainKey.newBuilder().setIteration(iteration).setSeed(ByteString.copyFrom((byte[])chainKey)).build();
        StorageProtos.SenderKeyStateStructure.SenderSigningKey.Builder signingKeyStructure = StorageProtos.SenderKeyStateStructure.SenderSigningKey.newBuilder().setPublic(ByteString.copyFrom((byte[])signatureKeyPublic.serialize()));
        if (signatureKeyPrivate.isPresent()) {
            signingKeyStructure.setPrivate(ByteString.copyFrom((byte[])signatureKeyPrivate.get().serialize()));
        }
        this.senderKeyStateStructure = (StorageProtos.SenderKeyStateStructure)StorageProtos.SenderKeyStateStructure.newBuilder().setSenderKeyId(id).setSenderChainKey(senderChainKeyStructure).setSenderSigningKey(signingKeyStructure).build();
    }

    public SenderKeyState(StorageProtos.SenderKeyStateStructure senderKeyStateStructure) {
        this.senderKeyStateStructure = senderKeyStateStructure;
    }

    public int getKeyId() {
        return this.senderKeyStateStructure.getSenderKeyId();
    }

    public SenderChainKey getSenderChainKey() {
        return new SenderChainKey(this.senderKeyStateStructure.getSenderChainKey().getIteration(), this.senderKeyStateStructure.getSenderChainKey().getSeed().toByteArray());
    }

    public void setSenderChainKey(SenderChainKey chainKey) {
        StorageProtos.SenderKeyStateStructure.SenderChainKey senderChainKeyStructure = (StorageProtos.SenderKeyStateStructure.SenderChainKey)StorageProtos.SenderKeyStateStructure.SenderChainKey.newBuilder().setIteration(chainKey.getIteration()).setSeed(ByteString.copyFrom((byte[])chainKey.getSeed())).build();
        this.senderKeyStateStructure = (StorageProtos.SenderKeyStateStructure)((StorageProtos.SenderKeyStateStructure.Builder)this.senderKeyStateStructure.toBuilder()).setSenderChainKey(senderChainKeyStructure).build();
    }

    public ECPublicKey getSigningKeyPublic() throws InvalidKeyException {
        return Curve.decodePoint(this.senderKeyStateStructure.getSenderSigningKey().getPublic().toByteArray(), 0);
    }

    public ECPrivateKey getSigningKeyPrivate() {
        return Curve.decodePrivatePoint(this.senderKeyStateStructure.getSenderSigningKey().getPrivate().toByteArray());
    }

    public boolean hasSenderMessageKey(int iteration) {
        for (StorageProtos.SenderKeyStateStructure.SenderMessageKey senderMessageKey : this.senderKeyStateStructure.getSenderMessageKeysList()) {
            if (senderMessageKey.getIteration() != iteration) continue;
            return true;
        }
        return false;
    }

    public void addSenderMessageKey(SenderMessageKey senderMessageKey) {
        StorageProtos.SenderKeyStateStructure.SenderMessageKey senderMessageKeyStructure = (StorageProtos.SenderKeyStateStructure.SenderMessageKey)StorageProtos.SenderKeyStateStructure.SenderMessageKey.newBuilder().setIteration(senderMessageKey.getIteration()).setSeed(ByteString.copyFrom((byte[])senderMessageKey.getSeed())).build();
        StorageProtos.SenderKeyStateStructure.Builder builder = (StorageProtos.SenderKeyStateStructure.Builder)this.senderKeyStateStructure.toBuilder();
        builder.addSenderMessageKeys(senderMessageKeyStructure);
        if (builder.getSenderMessageKeysCount() > 2000) {
            builder.removeSenderMessageKeys(0);
        }
        this.senderKeyStateStructure = (StorageProtos.SenderKeyStateStructure)builder.build();
    }

    public SenderMessageKey removeSenderMessageKey(int iteration) {
        LinkedList<StorageProtos.SenderKeyStateStructure.SenderMessageKey> keys = new LinkedList<StorageProtos.SenderKeyStateStructure.SenderMessageKey>(this.senderKeyStateStructure.getSenderMessageKeysList());
        Iterator iterator = keys.iterator();
        StorageProtos.SenderKeyStateStructure.SenderMessageKey result = null;
        while (iterator.hasNext()) {
            StorageProtos.SenderKeyStateStructure.SenderMessageKey senderMessageKey = (StorageProtos.SenderKeyStateStructure.SenderMessageKey)iterator.next();
            if (senderMessageKey.getIteration() != iteration) continue;
            result = senderMessageKey;
            iterator.remove();
            break;
        }
        this.senderKeyStateStructure = (StorageProtos.SenderKeyStateStructure)((StorageProtos.SenderKeyStateStructure.Builder)this.senderKeyStateStructure.toBuilder()).clearSenderMessageKeys().addAllSenderMessageKeys(keys).build();
        if (result != null) {
            return new SenderMessageKey(result.getIteration(), result.getSeed().toByteArray());
        }
        return null;
    }

    public StorageProtos.SenderKeyStateStructure getStructure() {
        return this.senderKeyStateStructure;
    }
}

