/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.protocol;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.InvalidVersionException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.protocol.SignalProtos;
import org.whispersystems.libsignal.util.ByteUtil;
import org.whispersystems.libsignal.util.guava.Optional;

public class PreKeySignalMessage
implements CiphertextMessage {
    private final int version;
    private final int registrationId;
    private final Optional<Integer> preKeyId;
    private final int signedPreKeyId;
    private final ECPublicKey baseKey;
    private final IdentityKey identityKey;
    private final SignalMessage message;
    private final byte[] serialized;

    public PreKeySignalMessage(byte[] serialized) throws InvalidMessageException, InvalidVersionException {
        try {
            this.version = ByteUtil.highBitsToInt(serialized[0]);
            if (this.version > 3) {
                throw new InvalidVersionException("Unknown version: " + this.version);
            }
            if (this.version < 3) {
                throw new LegacyMessageException("Legacy version: " + this.version);
            }
            SignalProtos.PreKeySignalMessage preKeyWhisperMessage = SignalProtos.PreKeySignalMessage.parseFrom(ByteString.copyFrom((byte[])serialized, (int)1, (int)(serialized.length - 1)));
            if (!(preKeyWhisperMessage.hasSignedPreKeyId() && preKeyWhisperMessage.hasBaseKey() && preKeyWhisperMessage.hasIdentityKey() && preKeyWhisperMessage.hasMessage())) {
                throw new InvalidMessageException("Incomplete message.");
            }
            this.serialized = serialized;
            this.registrationId = preKeyWhisperMessage.getRegistrationId();
            this.preKeyId = preKeyWhisperMessage.hasPreKeyId() ? Optional.of(preKeyWhisperMessage.getPreKeyId()) : Optional.absent();
            this.signedPreKeyId = preKeyWhisperMessage.hasSignedPreKeyId() ? preKeyWhisperMessage.getSignedPreKeyId() : -1;
            this.baseKey = Curve.decodePoint(preKeyWhisperMessage.getBaseKey().toByteArray(), 0);
            this.identityKey = new IdentityKey(Curve.decodePoint(preKeyWhisperMessage.getIdentityKey().toByteArray(), 0));
            this.message = new SignalMessage(preKeyWhisperMessage.getMessage().toByteArray());
        }
        catch (InvalidProtocolBufferException | InvalidKeyException | LegacyMessageException e) {
            throw new InvalidMessageException(e);
        }
    }

    public PreKeySignalMessage(int messageVersion, int registrationId, Optional<Integer> preKeyId, int signedPreKeyId, ECPublicKey baseKey, IdentityKey identityKey, SignalMessage message) {
        this.version = messageVersion;
        this.registrationId = registrationId;
        this.preKeyId = preKeyId;
        this.signedPreKeyId = signedPreKeyId;
        this.baseKey = baseKey;
        this.identityKey = identityKey;
        this.message = message;
        SignalProtos.PreKeySignalMessage.Builder builder = SignalProtos.PreKeySignalMessage.newBuilder().setSignedPreKeyId(signedPreKeyId).setBaseKey(ByteString.copyFrom((byte[])baseKey.serialize())).setIdentityKey(ByteString.copyFrom((byte[])identityKey.serialize())).setMessage(ByteString.copyFrom((byte[])message.serialize())).setRegistrationId(registrationId);
        if (preKeyId.isPresent()) {
            builder.setPreKeyId(preKeyId.get());
        }
        byte[] versionBytes = new byte[]{ByteUtil.intsToByteHighAndLow(this.version, 3)};
        byte[] messageBytes = ((SignalProtos.PreKeySignalMessage)builder.build()).toByteArray();
        this.serialized = ByteUtil.combine(versionBytes, messageBytes);
    }

    public int getMessageVersion() {
        return this.version;
    }

    public IdentityKey getIdentityKey() {
        return this.identityKey;
    }

    public int getRegistrationId() {
        return this.registrationId;
    }

    public Optional<Integer> getPreKeyId() {
        return this.preKeyId;
    }

    public int getSignedPreKeyId() {
        return this.signedPreKeyId;
    }

    public ECPublicKey getBaseKey() {
        return this.baseKey;
    }

    public SignalMessage getWhisperMessage() {
        return this.message;
    }

    @Override
    public byte[] serialize() {
        return this.serialized;
    }

    @Override
    public int getType() {
        return 3;
    }
}

