/*
 * Decompiled with CFR 0.152.
 */
package fr.dutra.tools.maven.deptree.core;

import fr.dutra.tools.maven.deptree.core.StandardTextVisitor;
import java.io.Serializable;
import java.util.LinkedList;

public class Node
implements Serializable {
    private static final long serialVersionUID = 5530155206443082802L;
    private final String groupId;
    private final String artifactId;
    private final String packaging;
    private final String classifier;
    private final String version;
    private final String scope;
    private final String description;
    private final boolean omitted;
    private Node parent;
    private final LinkedList<Node> childNodes = new LinkedList();

    public Node(String groupId, String artifactId, String packaging, String classifier, String version, String scope, String description, boolean omitted) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packaging = packaging;
        this.classifier = classifier;
        this.version = version;
        this.scope = scope;
        this.description = description;
        this.omitted = omitted;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isOmitted() {
        return this.omitted;
    }

    public Node getParent() {
        return this.parent;
    }

    public LinkedList<Node> getChildNodes() {
        return this.childNodes;
    }

    public boolean addChildNode(Node o) {
        o.parent = this;
        return this.childNodes.add(o);
    }

    public boolean remove(Node o) {
        return this.childNodes.remove(o);
    }

    public Node getChildNode(int index) {
        return this.childNodes.get(index);
    }

    public Node getFirstChildNode() {
        return this.childNodes.getFirst();
    }

    public Node getLastChildNode() {
        return this.childNodes.getLast();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.childNodes == null ? 0 : this.childNodes.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.omitted ? 1231 : 1237);
        result = 31 * result + (this.packaging == null ? 0 : this.packaging.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.childNodes == null ? other.childNodes != null : !this.childNodes.equals(other.childNodes)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.omitted != other.omitted) {
            return false;
        }
        if (this.packaging == null ? other.packaging != null : !this.packaging.equals(other.packaging)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public Node clone() {
        Node clone = new Node(this.groupId, this.artifactId, this.packaging, this.classifier, this.version, this.scope, this.description, this.omitted);
        for (Node childNode : this.childNodes) {
            clone.addChildNode(childNode.clone());
        }
        return clone;
    }

    public String toString() {
        StandardTextVisitor visitor = new StandardTextVisitor();
        visitor.visit(this.parent == null ? this : this.clone());
        return visitor.toString();
    }

    public String getArtifactCanonicalForm() {
        StringBuilder builder = new StringBuilder();
        if (this.omitted) {
            builder.append("(");
        }
        builder.append(this.groupId);
        builder.append(":");
        builder.append(this.artifactId);
        builder.append(":");
        builder.append(this.packaging);
        if (this.classifier != null) {
            builder.append(":");
            builder.append(this.classifier);
        }
        builder.append(":");
        builder.append(this.version);
        if (this.scope != null) {
            builder.append(":");
            builder.append(this.scope);
        }
        if (this.omitted) {
            builder.append(" - ");
            builder.append(this.description);
            builder.append(")");
        } else if (this.description != null) {
            builder.append(" (");
            builder.append(this.description);
            builder.append(")");
        }
        return builder.toString();
    }
}

