/*
 * Decompiled with CFR 0.152.
 */
package fr.dutra.tools.maven.deptree.core;

import fr.dutra.tools.maven.deptree.core.AbstractLineBasedParser;
import fr.dutra.tools.maven.deptree.core.Node;
import fr.dutra.tools.maven.deptree.core.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TgfParser
extends AbstractLineBasedParser {
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private Node root;
    private ParsePhase phase = ParsePhase.NODE;

    @Override
    public Node parse(Reader reader) throws ParseException {
        try {
            this.lines = this.splitLines(reader);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        if (this.lines.isEmpty()) {
            return null;
        }
        while (this.lineIndex < this.lines.size()) {
            this.parseLine();
            ++this.lineIndex;
        }
        return this.root;
    }

    private void parseLine() {
        String line = (String)this.lines.get(this.lineIndex);
        if ("#".equals(line)) {
            this.phase = ParsePhase.EDGE;
        } else if (this.phase == ParsePhase.NODE) {
            String id = StringUtils.substringBefore((String)line, (String)" ");
            String artifact = line.contains("active project artifact:") ? this.extractActiveProjectArtifact() : StringUtils.substringAfter((String)line, (String)" ");
            Node node = this.parseArtifactString(artifact);
            if (this.root == null) {
                this.root = node;
            }
            this.nodes.put(id, node);
        } else {
            String parentId = StringUtils.substringBefore((String)line, (String)" ");
            String childId = StringUtils.substringBetween((String)line, (String)" ");
            Node parent = this.nodes.get(parentId);
            Node child = this.nodes.get(childId);
            parent.addChildNode(child);
        }
    }

    private static enum ParsePhase {
        NODE,
        EDGE;

    }
}

