/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.whitesource.agent.DependencyInfoFactory;
import org.whitesource.agent.api.model.DependencyInfo;

public class DependencyCalculator {
    private static final List<String> progressAnimation = Arrays.asList("|", "/", "-", "\\");
    private static final int ANIMATION_FRAMES = progressAnimation.size();
    private final boolean showProgressBar;
    private int animationIndex = 0;

    public DependencyCalculator(boolean showProgressBar) {
        this.showProgressBar = showProgressBar;
        this.animationIndex = 0;
    }

    public Collection<DependencyInfo> createDependencies(boolean scmConnector, int totalFiles, Map<File, Collection<String>> fileMap, Collection<String> excludedCopyrights, boolean partialSha1Match) {
        return this.createDependencies(scmConnector, totalFiles, fileMap, excludedCopyrights, partialSha1Match, false, false);
    }

    public Collection<DependencyInfo> createDependencies(boolean scmConnector, int totalFiles, Map<File, Collection<String>> fileMap, Collection<String> excludedCopyrights, boolean partialSha1Match, boolean calculateHints, boolean calculateMd5) {
        ArrayList<DependencyInfo> allDependencies = new ArrayList<DependencyInfo>();
        if (this.showProgressBar) {
            this.displayProgress(0, totalFiles);
        }
        int index = 1;
        for (Map.Entry<File, Collection<String>> entry : fileMap.entrySet()) {
            for (String fileName : entry.getValue()) {
                DependencyInfoFactory factory = new DependencyInfoFactory(excludedCopyrights, partialSha1Match, calculateHints, calculateMd5);
                DependencyInfo originalDependencyInfo = factory.createDependencyInfo(entry.getKey(), fileName);
                if (originalDependencyInfo != null) {
                    if (scmConnector) {
                        originalDependencyInfo.setSystemPath(fileName.replace("\\", "/"));
                    }
                    allDependencies.add(originalDependencyInfo);
                }
                if (this.showProgressBar) {
                    this.displayProgress(index, totalFiles);
                }
                ++index;
            }
        }
        return allDependencies;
    }

    private void displayProgress(int index, int totalFiles) {
        int i;
        StringBuilder sb = new StringBuilder("[INFO] ");
        int actualAnimationIndex = this.animationIndex % (ANIMATION_FRAMES * 4);
        sb.append(progressAnimation.get(actualAnimationIndex / 4 % ANIMATION_FRAMES));
        ++this.animationIndex;
        sb.append(" [");
        double percentage = (double)index / (double)totalFiles * 100.0;
        int progressionBlocks = (int)(percentage / 3.0);
        for (i = 0; i < progressionBlocks; ++i) {
            sb.append("#");
        }
        for (i = progressionBlocks; i < 33; ++i) {
            sb.append(" ");
        }
        sb.append("] {0}% - {1} of {2} files\r");
        System.out.print(MessageFormat.format(sb.toString(), (int)percentage, index, totalFiles));
        if (index == totalFiles) {
            System.out.print("                                                                                  \r");
        }
    }
}

