/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;

public class ResolutionResult {
    private Map<AgentProjectInfo, Path> resolvedProjects;
    private Collection<String> excludes;
    private final DependencyType dependencyType;
    private final String topLevelFolder;

    public ResolutionResult(Map<AgentProjectInfo, Path> resolvedProjects, Collection<String> excludes, DependencyType dependencyType, String topLevelFolder) {
        this.resolvedProjects = resolvedProjects;
        this.excludes = excludes;
        this.dependencyType = dependencyType;
        this.topLevelFolder = topLevelFolder;
    }

    public ResolutionResult(Collection<DependencyInfo> dependencies, Iterable<String> excludes, DependencyType dependencyType, String topLevelFolder) {
        AgentProjectInfo projectInfo = new AgentProjectInfo();
        dependencies.forEach(dependencyInfo -> projectInfo.getDependencies().add(dependencyInfo));
        this.resolvedProjects = new HashMap<AgentProjectInfo, Path>();
        this.resolvedProjects.put(projectInfo, Paths.get(topLevelFolder, new String[0]));
        this.excludes = new ArrayList<String>();
        this.dependencyType = dependencyType;
        this.topLevelFolder = topLevelFolder;
        excludes.forEach(exclude -> this.excludes.add((String)exclude));
    }

    public Collection<String> getExcludes() {
        return this.excludes;
    }

    public Map<AgentProjectInfo, Path> getResolvedProjects() {
        return this.resolvedProjects;
    }

    public DependencyType getDependencyType() {
        return this.dependencyType;
    }

    public String getTopLevelFolder() {
        return this.topLevelFolder;
    }
}

