/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.dependency.resolver.docker.AbstractParser;
import org.whitesource.agent.dependency.resolver.docker.Package;

public class ArchLinuxParser
extends AbstractParser {
    private final Logger logger = LoggerFactory.getLogger(ArchLinuxParser.class);
    private static final String PACKAGE = "%NAME%";
    private static final String VERSION = "%VERSION%";
    private static final String ARCHITECTURE = "%ARCH%";
    private static final String DESC = "desc";
    private static final String ARCH_LINUX_PACKAGE_PATTERN = "{0}-{1}-{2}.pkg.tar.xz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Collection<DependencyInfo> parse(File dir) {
        BufferedReader br = null;
        FileReader fr = null;
        LinkedList<DependencyInfo> dependencyInfos = new LinkedList<DependencyInfo>();
        if (dir.isDirectory()) {
            LinkedList<File> files = new LinkedList<File>();
            this.getDescFiles(dir, files);
            if (!files.isEmpty()) {
                for (File file : files) {
                    try {
                        Object dependencyInfo = null;
                        Package packageInfo = new Package();
                        fr = new FileReader(file);
                        br = new BufferedReader(fr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            switch (line) {
                                case "%NAME%": {
                                    packageInfo.setPackageName(br.readLine());
                                    break;
                                }
                                case "%VERSION%": {
                                    packageInfo.setVersion(br.readLine());
                                    break;
                                }
                                case "%ARCH%": {
                                    packageInfo.setArchitecture(br.readLine());
                                    break;
                                }
                            }
                        }
                        dependencyInfos.add(this.createDependencyInfo(packageInfo));
                    }
                    catch (FileNotFoundException e) {
                        this.logger.error("Error getting package data", (Object)e.getMessage());
                        ArchLinuxParser.closeStream(br, fr);
                        continue;
                    }
                    catch (IOException e2) {
                        this.logger.error("Error getting package data", (Object)e2.getMessage());
                        {
                            catch (Throwable throwable) {
                                ArchLinuxParser.closeStream(br, fr);
                                throw throwable;
                            }
                        }
                        ArchLinuxParser.closeStream(br, fr);
                        continue;
                    }
                    ArchLinuxParser.closeStream(br, fr);
                }
            }
        }
        return dependencyInfos;
    }

    @Override
    public File findFile(String[] files, String pathToPackageManagerFolder) {
        int max = 0;
        File archLinuxPackageManagerFile = null;
        for (String filepath : files) {
            String descPath;
            File file;
            int descStartIndex;
            if (!filepath.contains(pathToPackageManagerFolder) || !filepath.endsWith(DESC) || (descStartIndex = filepath.lastIndexOf(pathToPackageManagerFolder)) <= 0 || (file = new File(descPath = filepath.substring(0, descStartIndex + pathToPackageManagerFolder.length()))).listFiles() == null || max >= file.listFiles().length) continue;
            max = file.listFiles().length;
            archLinuxPackageManagerFile = file;
        }
        if (archLinuxPackageManagerFile != null) {
            return archLinuxPackageManagerFile;
        }
        return null;
    }

    private void getDescFiles(File dir, Collection<File> files) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.getDescFiles(file, files);
                    continue;
                }
                if (!file.getName().equals(DESC)) continue;
                files.add(file);
            }
        }
    }

    private DependencyInfo createDependencyInfo(Package packageInfo) {
        DependencyInfo dependencyInfo = null;
        if (StringUtils.isNotBlank((String)packageInfo.getPackageName()) && StringUtils.isNotBlank((String)packageInfo.getVersion()) && StringUtils.isNotBlank((String)packageInfo.getArchitecture())) {
            dependencyInfo = new DependencyInfo(null, MessageFormat.format(ARCH_LINUX_PACKAGE_PATTERN, packageInfo.getPackageName(), packageInfo.getVersion(), packageInfo.getArchitecture()), packageInfo.getVersion());
        }
        if (dependencyInfo != null) {
            return dependencyInfo;
        }
        return null;
    }
}

