/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.gradle;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.dependency.resolver.gradle.MvnCommand;
import org.whitesource.agent.utils.Cli;
import org.whitesource.agent.utils.CommandLineProcess;

class GradleCli
extends Cli {
    private final Logger logger = LoggerFactory.getLogger(GradleCli.class);
    protected static final String GRADLE_ASSEMBLE = "assemble";
    private final String GRADLE_COMMAND = "gradle";
    private final String GRADLE_COMMAND_W_WINDOWS = "gradlew";
    private final String GRADLE_COMMAND_W_LINUX = "./gradlew";

    GradleCli() {
    }

    public List<String> runGradleCmd(String rootDirectory, String[] params) {
        block5: {
            try {
                CommandLineProcess commandLineProcess = new CommandLineProcess(rootDirectory, params);
                List<String> lines = commandLineProcess.executeProcess();
                if (commandLineProcess.isErrorInProcess()) {
                    this.setGradleCommandByEnv(params);
                    commandLineProcess = new CommandLineProcess(rootDirectory, params);
                    lines = commandLineProcess.executeProcess();
                    if (!commandLineProcess.isErrorInProcess()) {
                        return lines;
                    }
                    break block5;
                }
                return lines;
            }
            catch (IOException e) {
                if (StringUtils.isNotBlank((String)params[0]) && "gradle".equals(params[0])) {
                    this.setGradleCommandByEnv(params);
                    return this.runGradleCmd(rootDirectory, params);
                }
                this.logger.warn("Error getting dependencies after running {} on {}, {}", new Object[]{params, rootDirectory, e.getMessage()});
                this.logger.debug("Error: {}", (Object[])e.getStackTrace());
            }
        }
        return null;
    }

    private void setGradleCommandByEnv(String[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].equals("gradle")) continue;
            if (DependencyCollector.isWindows()) {
                params[i] = "gradlew";
                break;
            }
            params[i] = "./gradlew";
            break;
        }
    }

    protected String[] getGradleCommandParams(MvnCommand command) {
        return super.getCommandParams("gradle", command.name());
    }
}

