/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.maven;

import fr.dutra.tools.maven.deptree.core.InputType;
import fr.dutra.tools.maven.deptree.core.Node;
import fr.dutra.tools.maven.deptree.core.ParseException;
import fr.dutra.tools.maven.deptree.core.Parser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLinesParser {
    private Logger logger = LoggerFactory.getLogger(MavenLinesParser.class);
    private static final String MAVEN_DEPENDENCY_PLUGIN_TREE = "maven-dependency-plugin:";
    private static final String INFO = "[INFO] ";
    private static final String UTF_8 = "UTF-8";

    public List<Node> parseLines(List<String> lines) {
        List<List<String>> projectsLines = lines.stream().filter(line -> line.contains(INFO)).map(line -> line.replace(INFO, "")).collect(MavenLinesParser.splitBySeparator(formattedLines -> formattedLines.contains(MAVEN_DEPENDENCY_PLUGIN_TREE)));
        this.logger.info("Start parsing pom files");
        ArrayList<Node> nodes = new ArrayList<Node>();
        projectsLines.forEach(singleProjectLines -> {
            if (((String)singleProjectLines.get(0)).contains(":")) {
                String mvnLines = String.join((CharSequence)System.lineSeparator(), singleProjectLines);
                try (ByteArrayInputStream is = new ByteArrayInputStream(mvnLines.getBytes(StandardCharsets.UTF_8.name()));
                     InputStreamReader lineReader = new InputStreamReader((InputStream)is, UTF_8);){
                    Parser parser = InputType.TEXT.newParser();
                    Node tree = parser.parse((Reader)lineReader);
                    nodes.add(tree);
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.warn("unsupportedEncoding error parsing output : {}", (Object)e.getMessage());
                    this.logger.debug("unsupportedEncoding error parsing output : {}", (Object[])e.getStackTrace());
                }
                catch (ParseException e) {
                    this.logger.warn("error parsing output : {} ", (Object)e.getMessage());
                    this.logger.debug("error parsing output : {} ", (Object[])e.getStackTrace());
                }
                catch (Exception e) {
                    this.logger.debug("error parsing output : {}", (Object)e.getMessage());
                    this.logger.debug("error parsing output : {} {}", (Object)e.getMessage(), (Object)mvnLines);
                }
            }
        });
        return nodes;
    }

    private static Collector<String, List<List<String>>, List<List<String>>> splitBySeparator(Predicate<String> sep) {
        return Collector.of(() -> new ArrayList<ArrayList>(Arrays.asList(new ArrayList())), (l, elem) -> {
            if (sep.test((String)elem)) {
                l.add(new ArrayList());
            } else {
                ((List)l.get(l.size() - 1)).add(elem);
            }
        }, (l1, l2) -> {
            ((List)l1.get(l1.size() - 1)).addAll((Collection)l2.remove(0));
            l1.addAll(l2);
            return l1;
        }, new Collector.Characteristics[0]);
    }
}

