/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.maven;

import fr.dutra.tools.maven.deptree.core.Node;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.dependency.resolver.maven.MavenLinesParser;
import org.whitesource.agent.hash.ChecksumUtils;
import org.whitesource.agent.utils.CommandLineProcess;

public class MavenTreeDependencyCollector
extends DependencyCollector {
    private static final Logger logger = LoggerFactory.getLogger(MavenTreeDependencyCollector.class);
    private static final String MVN_PARAMS_M2PATH_PATH = "help:evaluate";
    private static final String MVN_PARAMS_M2PATH_LOCAL = "-Dexpression=settings.localRepository";
    private static final String MVN_PARAMS_TREE = "dependency:tree";
    private static final String MVN_COMMAND = "mvn";
    private static final String SCOPE_TEST = "test";
    private static final String SCOPE_PROVIDED = "provided";
    private static final String USER_HOME = "user.home";
    private static final String M2 = ".m2";
    private static final String REPOSITORY = "repository";
    private static final String ALL = "All";
    private static final String POM = "pom";
    private static final String B_PARAMETER = "-B";
    public static final String TEST_JAR = "test-jar";
    public static final String JAR = "jar";
    protected String M2Path;
    private final Set<String> mavenIgnoredScopes;
    private boolean showMavenTreeError;
    private boolean ignorePomModules;
    private MavenLinesParser mavenLinesParser = new MavenLinesParser();

    public MavenTreeDependencyCollector(String[] mavenIgnoredScopes, boolean ignorePomModules) {
        this.mavenIgnoredScopes = new HashSet<String>();
        if (mavenIgnoredScopes == null) {
            this.mavenIgnoredScopes.add(SCOPE_PROVIDED);
            this.mavenIgnoredScopes.add(SCOPE_TEST);
        } else if (mavenIgnoredScopes.length != 1 || !mavenIgnoredScopes[0].equals(ALL)) {
            Arrays.stream(mavenIgnoredScopes).filter(exclude -> StringUtils.isBlank((String)exclude)).map(exclude -> this.mavenIgnoredScopes.add((String)exclude));
        }
        this.ignorePomModules = ignorePomModules;
    }

    @Override
    public Collection<AgentProjectInfo> collectDependencies(String rootDirectory) {
        if (StringUtils.isBlank((String)this.M2Path)) {
            this.M2Path = this.getMavenM2Path(".");
        }
        HashMap pathToDependenciesMap = new HashMap();
        Collection<Object> projects = new ArrayList<AgentProjectInfo>();
        try {
            CommandLineProcess mvnDependencies = new CommandLineProcess(rootDirectory, this.getLsCommandParamsBatchMode());
            List<String> lines = mvnDependencies.executeProcess();
            if (mvnDependencies.isErrorInProcess()) {
                logger.debug("Failed to execute the command {}", (Object[])this.getLsCommandParamsBatchMode());
                mvnDependencies = new CommandLineProcess(rootDirectory, this.getLsCommandParams());
                lines = mvnDependencies.executeProcess();
            }
            if (!mvnDependencies.isErrorInProcess()) {
                List<Node> nodes = this.mavenLinesParser.parseLines(lines);
                logger.info("End parsing pom files , found : " + String.join((CharSequence)",", nodes.stream().map(node -> node.getArtifactId()).collect(Collectors.toList())));
                projects = nodes.stream().filter(node -> !this.ignorePomModules || this.ignorePomModules && !node.getPackaging().equals(POM)).map(tree -> {
                    LinkedList dependencies = new LinkedList();
                    Stream<Node> nodeStream = tree.getChildNodes().stream().filter(node -> !this.mavenIgnoredScopes.contains(node.getScope()));
                    dependencies.addAll(nodeStream.map(node -> this.getDependencyFromNode((Node)node, pathToDependenciesMap)).collect(Collectors.toList()));
                    Map<String, String> pathToSha1Map = ((Stream)pathToDependenciesMap.keySet().stream().distinct().parallel()).collect(Collectors.toMap(file -> file, file -> this.getSha1((String)file)));
                    pathToSha1Map.entrySet().forEach(pathSha1Pair -> ((List)pathToDependenciesMap.get(pathSha1Pair.getKey())).stream().forEach(dependency -> {
                        dependency.setSha1((String)pathSha1Pair.getValue());
                        dependency.setSystemPath((String)pathSha1Pair.getKey());
                    }));
                    AgentProjectInfo projectInfo = new AgentProjectInfo();
                    projectInfo.setCoordinates(new Coordinates(tree.getGroupId(), tree.getArtifactId(), tree.getVersion()));
                    dependencies.stream().filter(dependency -> StringUtils.isNotEmpty((String)dependency.getSha1())).forEach(dependency -> projectInfo.getDependencies().add(dependency));
                    return projectInfo;
                }).collect(Collectors.toList());
            } else {
                logger.warn("Failed to scan and send {}", (Object[])this.getLsCommandParams());
            }
        }
        catch (IOException e) {
            logger.warn("Error getting dependencies after running {} on {}, {}", new Object[]{this.getLsCommandParams(), rootDirectory, e.getMessage()});
            logger.debug("Error: {}", (Object[])e.getStackTrace());
        }
        if (projects != null && projects.isEmpty() && !this.showMavenTreeError) {
            logger.warn("Failed to getting dependencies after running '{}' Please install maven ", (Object[])this.getLsCommandParams());
            this.showMavenTreeError = true;
        }
        return projects;
    }

    protected String getSha1(String filePath) {
        try {
            return ChecksumUtils.calculateSHA1((File)new File(filePath));
        }
        catch (IOException e) {
            logger.warn("Failed getting " + filePath + ". File will not be sent to WhiteSource server.");
            return "";
        }
    }

    private DependencyInfo getDependencyFromNode(Node node, Map<String, List<DependencyInfo>> paths) {
        File jarFile;
        String shortName;
        logger.debug("converting node to dependency :" + node.getArtifactId());
        DependencyInfo dependency = new DependencyInfo(node.getGroupId(), node.getArtifactId(), node.getVersion());
        dependency.setDependencyType(DependencyType.MAVEN);
        dependency.setScope(node.getScope());
        dependency.setType(node.getPackaging());
        if (StringUtils.isBlank((String)node.getClassifier())) {
            shortName = dependency.getArtifactId() + "-" + dependency.getVersion() + "." + node.getPackaging();
        } else {
            String nodePackaging = node.getPackaging();
            if (nodePackaging.equals(TEST_JAR)) {
                nodePackaging = JAR;
            }
            shortName = dependency.getArtifactId() + "-" + dependency.getVersion() + "-" + node.getClassifier() + "." + nodePackaging;
        }
        String filePath = Paths.get(this.M2Path, dependency.getGroupId().replace(".", File.separator), dependency.getArtifactId(), dependency.getVersion(), shortName).toString();
        if (!paths.containsKey(filePath)) {
            paths.put(filePath, new ArrayList());
        }
        paths.get(filePath).add(dependency);
        if (StringUtils.isNotBlank((String)filePath) && (jarFile = new File(filePath)).exists()) {
            dependency.setFilename(jarFile.getName());
        }
        node.getChildNodes().forEach(childNode -> dependency.getChildren().add(this.getDependencyFromNode((Node)childNode, paths)));
        return dependency;
    }

    private String[] getLsCommandParams() {
        if (MavenTreeDependencyCollector.isWindows()) {
            return new String[]{"cmd", "/c", MVN_COMMAND, MVN_PARAMS_TREE};
        }
        return new String[]{MVN_COMMAND, MVN_PARAMS_TREE};
    }

    private String[] getLsCommandParamsBatchMode() {
        String[] commandParams = this.getLsCommandParams();
        String[] result = new String[commandParams.length + 1];
        for (int i = 0; i < commandParams.length; ++i) {
            result[i] = commandParams[i];
        }
        result[result.length - 1] = B_PARAMETER;
        return result;
    }

    protected String getMavenM2Path(String rootDirectory) {
        String currentUsersHomeDir = System.getProperty(USER_HOME);
        File m2Path = Paths.get(currentUsersHomeDir, M2, REPOSITORY).toFile();
        if (m2Path.exists()) {
            return m2Path.getAbsolutePath();
        }
        String[] params = null;
        params = MavenTreeDependencyCollector.isWindows() ? new String[]{"cmd", "/c", MVN_COMMAND, MVN_PARAMS_M2PATH_PATH, MVN_PARAMS_M2PATH_LOCAL} : new String[]{MVN_COMMAND, MVN_PARAMS_M2PATH_PATH, MVN_PARAMS_M2PATH_LOCAL};
        try {
            CommandLineProcess mvnProcess = new CommandLineProcess(rootDirectory, params);
            List<String> lines = mvnProcess.executeProcess();
            if (!mvnProcess.isErrorInProcess()) {
                Optional<String> pathLine = lines.stream().filter(line -> new File((String)line).exists()).findFirst();
                if (pathLine.isPresent()) {
                    return pathLine.get();
                }
                logger.warn("could not get m2 path : {} out: {}", (Object)rootDirectory, (Object)lines.stream().reduce("", String::concat));
                this.showMavenTreeError = true;
                return null;
            }
            logger.warn("Failed to scan and send {}", (Object[])this.getLsCommandParams());
            return null;
        }
        catch (IOException io) {
            logger.warn("could not get m2 path : {}", (Object)io.getMessage());
            this.showMavenTreeError = true;
            return null;
        }
    }
}

