/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.npm;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.dependency.resolver.BomFile;
import org.whitesource.agent.dependency.resolver.BomParser;

public class NpmBomParser
extends BomParser {
    private static String OPTIONAL_DEPENDENCIES = "optionalDependencies";
    private static String SHA1 = "_shasum";
    private static String NPM_PACKAGE_FORMAT = "{0}-{1}.tgz";
    private static String RESOLVED = "_resolved";
    private final Logger logger = LoggerFactory.getLogger(NpmBomParser.class);

    protected String getVersion(JSONObject json, String fileName) {
        if (json.has("version")) {
            return json.getString("version");
        }
        this.logger.debug("version not found in file {}", (Object)fileName);
        return "";
    }

    public static String getNpmArtifactId(String name, String version) {
        return MessageFormat.format(NPM_PACKAGE_FORMAT, name, version);
    }

    @Override
    protected BomFile parseBomFile(String jsonText, String localFileName) {
        JSONObject json = new JSONObject(jsonText);
        String name = json.getString("name");
        String version = this.getVersion(json, localFileName);
        Map<String, String> dependencies = this.getDependenciesFromJson(json, "dependencies");
        Map<String, String> optionalDependencies = this.getDependenciesFromJson(json, OPTIONAL_DEPENDENCIES);
        String fileName = this.getFilename(name, version);
        String sha1 = "";
        String resolved = null;
        if (json.has(RESOLVED)) {
            resolved = json.getString(RESOLVED);
        }
        if (json.has(SHA1)) {
            sha1 = json.getString(SHA1);
        } else {
            this.logger.debug("shasum not found in file {}", (Object)localFileName);
        }
        BomFile bom = new BomFile(name, version, sha1, fileName, localFileName, dependencies, optionalDependencies, resolved);
        return bom;
    }

    @Override
    protected String getFilename(String name, String version) {
        return NpmBomParser.getNpmArtifactId(name, version);
    }

    private Map<String, String> getDependenciesFromJson(JSONObject json, String keyJson) {
        HashMap<String, String> nameVersionMap = new HashMap<String, String>();
        if (json.has(keyJson)) {
            JSONObject optionals = json.getJSONObject(keyJson);
            Iterator keys = optionals.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                nameVersionMap.put(key, optionals.getString(key));
            }
        }
        return nameVersionMap;
    }
}

