/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.npm;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jgit.util.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.BomFile;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.npm.NpmBomParser;
import org.whitesource.agent.dependency.resolver.npm.NpmLsJsonDependencyCollector;
import org.whitesource.agent.dependency.resolver.npm.YarnDependencyCollector;
import org.whitesource.agent.utils.FilesScanner;
import org.whitesource.fs.StatusCode;

public class NpmDependencyResolver
extends AbstractDependencyResolver {
    private final Logger logger = LoggerFactory.getLogger(NpmDependencyResolver.class);
    private static final String PACKAGE_JSON = "package.json";
    private static final String TYPE_SCRIPT_EXTENSION = ".ts";
    private static final String TSX_EXTENSION = ".tsx";
    private static final String JS_PATTERN = "**/*.js";
    private static final String EXAMPLE = "**/example/**/";
    private static final String EXAMPLES = "**/examples/**/";
    private static final String WS_BOWER_FOLDER = "**/.ws_bower/**/";
    private static final String TEST = "**/test/**/";
    private static final long NPM_DEFAULT_LS_TIMEOUT = 60L;
    private static final String VERSIONS = "versions";
    private static final String DIST = "dist";
    private static final String SHASUM = "shasum";
    private static final String EXCLUDE_TOP_FOLDER = "node_modules";
    public static final String AUTHORIZATION = "Authorization";
    public static final String BEARER = "Bearer";
    private static final int NUM_THREADS = 8;
    private final NpmLsJsonDependencyCollector bomCollector;
    private final NpmBomParser bomParser;
    private final boolean ignoreJavaScriptFiles;
    private final boolean runPreStep;
    private final FilesScanner filesScanner;
    private final String npmAccessToken;
    private final boolean npmYarnProject;

    public NpmDependencyResolver(boolean includeDevDependencies, boolean ignoreJavaScriptFiles, long npmTimeoutDependenciesCollector, boolean runPreStep, boolean npmIgnoreNpmLsErrors, String npmAccessToken, boolean npmYarnProject, boolean ignoreScripts) {
        this.bomCollector = npmYarnProject ? new YarnDependencyCollector(includeDevDependencies, npmTimeoutDependenciesCollector, ignoreJavaScriptFiles, ignoreScripts) : new NpmLsJsonDependencyCollector(includeDevDependencies, npmTimeoutDependenciesCollector, npmIgnoreNpmLsErrors, ignoreScripts);
        this.bomParser = new NpmBomParser();
        this.ignoreJavaScriptFiles = ignoreJavaScriptFiles;
        this.runPreStep = runPreStep;
        this.filesScanner = new FilesScanner();
        this.npmAccessToken = npmAccessToken;
        this.npmYarnProject = npmYarnProject;
    }

    public NpmDependencyResolver(boolean runPreStep, String npmAccessToken) {
        this(false, true, 60L, runPreStep, false, npmAccessToken, false, false);
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("**/*ws_bower.json");
        excludes.add("**/*ws-log-response-bower.json");
        return excludes;
    }

    @Override
    public String[] getBomPattern() {
        return new String[]{"**/*package.json"};
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        if (this.runPreStep) {
            this.getDependencyCollector().executePreparationStep(topLevelFolder);
            String[] excludesArray = new String[this.getExcludes().size()];
            excludesArray = this.getExcludes().toArray(excludesArray);
            String[] otherBomFiles = this.filesScanner.getDirectoryContent(topLevelFolder, this.getBomPattern(), excludesArray, false, false);
            Arrays.stream(otherBomFiles).forEach(file -> bomFiles.add(Paths.get(topLevelFolder, file).toString()));
        }
        this.logger.debug("Attempting to parse package.json files");
        LinkedList<BomFile> parsedBomFiles = new LinkedList<BomFile>();
        Map<File, List<File>> mapBomFiles = bomFiles.stream().map(file -> new File((String)file)).collect(Collectors.groupingBy(File::getParentFile));
        List<File> files = mapBomFiles.entrySet().stream().map(entry -> {
            if (((List)entry.getValue()).size() > 1) {
                return ((List)entry.getValue()).stream().filter(this::fileShouldBeParsed).findFirst().get();
            }
            return (File)((List)entry.getValue()).stream().findFirst().get();
        }).collect(Collectors.toList());
        files.forEach(bomFile -> {
            BomFile parsedBomFile = this.getBomParser().parseBomFile(bomFile.getAbsolutePath());
            if (parsedBomFile != null && parsedBomFile.isValid()) {
                parsedBomFiles.add(parsedBomFile);
            }
        });
        this.logger.debug("Trying to collect dependencies via 'npm ls'");
        Collection<AgentProjectInfo> projects = this.getDependencyCollector().collectDependencies(topLevelFolder);
        Collection dependencies = projects.stream().flatMap(project -> project.getDependencies().stream()).collect(Collectors.toList());
        boolean lsSuccess = !this.getDependencyCollector().getNpmLsFailureStatus();
        boolean zeroDependenciesList = false;
        if (lsSuccess) {
            this.logger.debug("'npm ls succeeded");
            if (!dependencies.isEmpty()) {
                this.handleLsSuccess(parsedBomFiles, dependencies, this.npmAccessToken);
            } else {
                zeroDependenciesList = true;
            }
        } else {
            this.logger.debug("'npm ls failed");
            dependencies.addAll(this.collectPackageJsonDependencies(parsedBomFiles));
        }
        this.logger.debug("Creating excludes for .js files upon finding NPM dependencies");
        LinkedList<String> excludes = new LinkedList<String>();
        if (!dependencies.isEmpty() || zeroDependenciesList) {
            if (this.ignoreJavaScriptFiles) {
                excludes.addAll(this.normalizeLocalPath(projectFolder, topLevelFolder, Arrays.asList(JS_PATTERN, "**/*.ts", "**/*.tsx"), null));
            } else {
                excludes.addAll(this.normalizeLocalPath(projectFolder, topLevelFolder, Arrays.asList(JS_PATTERN, "**/*.ts", "**/*.tsx"), EXCLUDE_TOP_FOLDER));
            }
        }
        return new ResolutionResult(dependencies, excludes, this.getDependencyType(), topLevelFolder);
    }

    @Override
    protected Collection<String> getExcludes() {
        HashSet<String> excludes = new HashSet<String>();
        String bomPattern = this.getBomPattern()[0];
        excludes.add(EXAMPLE + bomPattern);
        excludes.add(EXAMPLES + bomPattern);
        excludes.add(WS_BOWER_FOLDER + bomPattern);
        excludes.add(TEST + bomPattern);
        excludes.addAll(this.getLanguageExcludes());
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return Arrays.asList(".js", TYPE_SCRIPT_EXTENSION, TSX_EXTENSION);
    }

    protected String getPreferredFileName() {
        return PACKAGE_JSON;
    }

    protected NpmBomParser getBomParser() {
        return this.bomParser;
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.NPM;
    }

    protected NpmLsJsonDependencyCollector getDependencyCollector() {
        return this.bomCollector;
    }

    protected boolean isMatchChildDependency(DependencyInfo childDependency, String name, String version) {
        return childDependency.getArtifactId().equals(NpmBomParser.getNpmArtifactId(name, version));
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.NPM.name();
    }

    protected void enrichDependency(DependencyInfo dependency, BomFile packageJson, String npmAccessToken) {
        String sha1 = packageJson.getSha1();
        String registryPackageUrl = packageJson.getRegistryPackageUrl();
        if (StringUtils.isEmptyOrNull((String)sha1) && !StringUtils.isEmptyOrNull((String)registryPackageUrl)) {
            sha1 = this.getSha1FromRegistryPackageUrl(registryPackageUrl, packageJson.isScopedPackage(), packageJson.getVersion(), npmAccessToken);
        }
        dependency.setSha1(sha1);
        dependency.setGroupId(packageJson.getName());
        dependency.setArtifactId(packageJson.getFileName());
        dependency.setVersion(packageJson.getVersion());
        dependency.setSystemPath(packageJson.getLocalFileName());
        dependency.setFilename(packageJson.getLocalFileName());
        dependency.setDependencyType(this.getDependencyType());
    }

    private String getSha1FromRegistryPackageUrl(String registryPackageUrl, boolean isScopeDep, String versionOfPackage, String npmAccessToken) {
        RestTemplate restTemplate = new RestTemplate();
        URI uriScopeDep = null;
        if (isScopeDep) {
            try {
                uriScopeDep = new URI(registryPackageUrl.replace(BomFile.DUMMY_PARAMETER_SCOPE_PACKAGE, "%2F"));
            }
            catch (Exception e) {
                this.logger.warn("Failed creating uri of {}", (Object)registryPackageUrl);
                return "";
            }
        }
        String responseFromRegistry = null;
        try {
            if (isScopeDep) {
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.set(AUTHORIZATION, "Bearer " + npmAccessToken);
                HttpEntity entity = new HttpEntity((MultiValueMap)httpHeaders);
                responseFromRegistry = (String)restTemplate.exchange(uriScopeDep, HttpMethod.GET, entity, String.class).getBody();
            } else {
                responseFromRegistry = (String)restTemplate.getForObject(registryPackageUrl, String.class, new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not reach the registry using the URL: {}. Got an error: {}", (Object)registryPackageUrl, (Object)e.getMessage());
            return "";
        }
        JSONObject jsonRegistry = new JSONObject(responseFromRegistry);
        String shasum = isScopeDep ? jsonRegistry.getJSONObject(VERSIONS).getJSONObject(versionOfPackage).getJSONObject(DIST).getString(SHASUM) : jsonRegistry.getJSONObject(DIST).getString(SHASUM);
        return shasum;
    }

    private Collection<DependencyInfo> collectPackageJsonDependencies(Collection<BomFile> packageJsons) {
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        ConcurrentHashMap<DependencyInfo, BomFile> dependencyPackageJsonMap = new ConcurrentHashMap<DependencyInfo, BomFile>();
        ExecutorService executorService = Executors.newWorkStealingPool(8);
        LinkedList<EnrichDependency> threadsCollection = new LinkedList<EnrichDependency>();
        for (BomFile packageJson : packageJsons) {
            if (packageJson == null || !packageJson.isValid()) continue;
            DependencyInfo dependency = new DependencyInfo();
            dependencies.add(dependency);
            threadsCollection.add(new EnrichDependency(packageJson, dependency, dependencyPackageJsonMap));
            this.logger.debug("Collect package.json of the dependency in the file: {}", (Object)dependency.getFilename());
        }
        this.runThreadCollection(executorService, threadsCollection);
        this.logger.debug("set hierarchy of the dependencies");
        HashMap<String, DependencyInfo> existDependencies = new HashMap<String, DependencyInfo>();
        HashMap<DependencyInfo, BomFile> dependencyPackageJsonMapWithoutDuplicates = new HashMap<DependencyInfo, BomFile>();
        for (Map.Entry entry : dependencyPackageJsonMap.entrySet()) {
            DependencyInfo keyDep = (DependencyInfo)entry.getKey();
            String key = keyDep.getSha1() + keyDep.getVersion() + keyDep.getArtifactId();
            if (existDependencies.containsKey(key)) continue;
            existDependencies.put(key, keyDep);
            dependencyPackageJsonMapWithoutDuplicates.put(keyDep, (BomFile)entry.getValue());
        }
        this.setHierarchy(dependencyPackageJsonMapWithoutDuplicates, existDependencies);
        return existDependencies.values();
    }

    private void runThreadCollection(ExecutorService executorService, Collection<EnrichDependency> threadsCollection) {
        try {
            executorService.invokeAll(threadsCollection);
            executorService.shutdown();
        }
        catch (InterruptedException e) {
            this.logger.error("One of the threads was interrupted, please try to scan again the project. Error: {}", (Throwable)e);
            System.exit(StatusCode.ERROR.getValue());
        }
    }

    private boolean fileShouldBeParsed(File file) {
        return file.getAbsolutePath().endsWith(this.getPreferredFileName());
    }

    private void setHierarchy(Map<DependencyInfo, BomFile> dependencyPackageJsonMap, Map<String, DependencyInfo> existDependencies) {
        dependencyPackageJsonMap.forEach((dependency, packageJson) -> packageJson.getDependencies().forEach((name, version) -> {
            DependencyInfo childDepGet;
            String key;
            Optional<DependencyInfo> childDep = dependencyPackageJsonMap.keySet().stream().filter(childDependency -> this.isMatchChildDependency((DependencyInfo)childDependency, (String)name, (String)version)).findFirst();
            if (childDep.isPresent() && !existDependencies.containsKey(key = (childDepGet = childDep.get()).getSha1() + childDepGet.getVersion() + childDepGet.getArtifactId())) {
                dependency.getChildren().add(childDep.get());
                existDependencies.put(key, childDepGet);
            }
        }));
    }

    private void handleLsSuccess(Collection<BomFile> packageJsonFiles, Collection<DependencyInfo> dependencies, String npmAccessToken) {
        Map resultFiles = packageJsonFiles.stream().filter(packageJson -> packageJson != null && packageJson.isValid()).filter(this.distinctByKey(BomFile::getFileName)).collect(Collectors.toMap(BomFile::getUniqueDependencyName, Function.identity()));
        this.logger.debug("Handling all dependencies");
        LinkedList<EnrichDependency> threadsCollection = new LinkedList<EnrichDependency>();
        dependencies.forEach(dependency -> this.handleLSDependencyRecursivelyImpl((DependencyInfo)dependency, resultFiles, (Collection<EnrichDependency>)threadsCollection, npmAccessToken));
        ExecutorService executorService = Executors.newWorkStealingPool(8);
        this.runThreadCollection(executorService, threadsCollection);
    }

    private void handleLSDependencyRecursivelyImpl(DependencyInfo dependency, Map<String, BomFile> resultFiles, Collection<EnrichDependency> threadsCollection, String npmAccessToken) {
        String uniqueName = BomFile.getUniqueDependencyName(dependency.getGroupId(), dependency.getVersion());
        BomFile packageJson = resultFiles.get(uniqueName);
        if (packageJson != null) {
            threadsCollection.add(new EnrichDependency(packageJson, dependency, npmAccessToken));
        } else {
            this.logger.debug("Dependency {} could not be retrieved. 'package.json' could not be found", (Object)dependency.getArtifactId());
        }
        this.logger.debug("handle the children dependencies in the file: {}", (Object)dependency.getFilename());
        dependency.getChildren().forEach(childDependency -> this.handleLSDependencyRecursivelyImpl((DependencyInfo)childDependency, resultFiles, threadsCollection, npmAccessToken));
    }

    private void removeDependenciesWithoutSha1(Collection<DependencyInfo> dependencies) {
        ArrayList childDependencies = new ArrayList();
        Iterator<DependencyInfo> iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            DependencyInfo dependencyInfo = iterator.next();
            if (!dependencyInfo.getSha1().isEmpty()) continue;
            childDependencies.addAll(dependencyInfo.getChildren());
            iterator.remove();
        }
        dependencies.addAll(childDependencies);
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    class EnrichDependency
    implements Callable<Void> {
        private BomFile packageJson;
        private DependencyInfo dependency;
        private ConcurrentHashMap<DependencyInfo, BomFile> dependencyPackageJsonMap;
        private String npmAccessToken;

        public EnrichDependency(BomFile packageJson, DependencyInfo dependency, String npmAccessToken) {
            this.packageJson = packageJson;
            this.dependency = dependency;
            this.dependencyPackageJsonMap = null;
            this.npmAccessToken = npmAccessToken;
        }

        public EnrichDependency(BomFile packageJson, DependencyInfo dependency, ConcurrentHashMap<DependencyInfo, BomFile> dependencyPackageJsonMap) {
            this.packageJson = packageJson;
            this.dependency = dependency;
            this.dependencyPackageJsonMap = dependencyPackageJsonMap;
        }

        @Override
        public Void call() {
            NpmDependencyResolver.this.enrichDependency(this.dependency, this.packageJson, this.npmAccessToken);
            if (this.dependencyPackageJsonMap != null) {
                this.dependencyPackageJsonMap.putIfAbsent(this.dependency, this.packageJson);
            }
            return null;
        }
    }
}

