/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.npm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.npm.NpmLsJsonDependencyCollector;
import org.whitesource.agent.utils.CommandLineProcess;

public class YarnDependencyCollector
extends NpmLsJsonDependencyCollector {
    protected static final String SUCCESS = "success";
    protected static final String RESOLVED = "resolved";
    protected static final String TGZ = ".tgz";
    protected static final String OPTIONAL_DEPENDENCIES = "optionalDependencies";
    protected static final String AT = "@";
    protected static final String NODE_MODULES = "node_modules";
    protected static final String PACKAGE_JSON = "package.json";
    protected static final String DEV_DEPENDENCIES = "devDependencies";
    private final Logger logger = LoggerFactory.getLogger(YarnDependencyCollector.class);
    private static final String YARN_COMMAND = YarnDependencyCollector.isWindows() ? "yarn.cmd" : "yarn";
    private String fileSeparator = System.getProperty("file.separator");
    private static final String YARN_LOCK = "yarn.lock";
    private Map<String, Object> devDependencies;

    public YarnDependencyCollector(boolean includeDevDependencies, long npmTimeoutDependenciesCollector, boolean ignoreNpmLsErrors, boolean ignoreScripts) {
        super(includeDevDependencies, npmTimeoutDependenciesCollector, ignoreNpmLsErrors, ignoreScripts);
    }

    @Override
    public Collection<AgentProjectInfo> collectDependencies(String folder) {
        if (!this.includeDevDependencies) {
            this.devDependencies = this.findDevDependencies(folder);
        }
        File yarnLock = new File(folder + this.fileSeparator + YARN_LOCK);
        boolean yarnLockFound = yarnLock.isFile();
        ArrayList<DependencyInfo> dependencies = new ArrayList();
        if (yarnLockFound) {
            dependencies = this.parseYarnLock(yarnLock);
        } else {
            this.npmLsFailureStatus = true;
        }
        return this.getSingleProjectList(dependencies);
    }

    @Override
    protected String[] getInstallParams() {
        return new String[]{YARN_COMMAND, "install"};
    }

    @Override
    public boolean executePreparationStep(String folder) {
        CommandLineProcess yarnInstallCommand = new CommandLineProcess(folder, this.getInstallParams());
        yarnInstallCommand.setTimeoutReadLineSeconds(this.npmTimeoutDependenciesCollector);
        try {
            List<String> linesOfYarnInstall = yarnInstallCommand.executeProcess();
            if (yarnInstallCommand.isErrorInProcess()) {
                for (String line : linesOfYarnInstall) {
                    if (!line.startsWith(SUCCESS)) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DependencyInfo> parseYarnLock(File yarnLock) {
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        HashMap<String, DependencyInfo> parentsMap = new HashMap<String, DependencyInfo>();
        HashMap<String, DependencyInfo> childrenMap = new HashMap<String, DependencyInfo>();
        FileReader fileReader = null;
        try {
            String currLine;
            fileReader = new FileReader(yarnLock.getPath());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            boolean insideDependencies = false;
            DependencyInfo dependencyInfo = null;
            while ((currLine = bufferedReader.readLine()) != null) {
                if (currLine.isEmpty() || currLine.startsWith("#") || currLine.trim().isEmpty()) {
                    insideDependencies = false;
                    continue;
                }
                this.logger.debug(currLine);
                if (currLine.startsWith(" ")) {
                    if (currLine.trim().startsWith("version")) {
                        String version = currLine.substring(currLine.indexOf("\"") + 1, currLine.lastIndexOf("\""));
                        dependencyInfo.setVersion(version);
                        dependencyInfo.setArtifactId(dependencyInfo.getGroupId() + "-" + version + TGZ);
                        continue;
                    }
                    if (currLine.trim().startsWith(RESOLVED)) {
                        String sha1 = currLine.substring(currLine.indexOf("#") + 1, currLine.lastIndexOf("\""));
                        dependencyInfo.setSha1(sha1);
                        continue;
                    }
                    if (currLine.trim().startsWith("dependencies") || currLine.trim().startsWith(OPTIONAL_DEPENDENCIES)) {
                        insideDependencies = true;
                        continue;
                    }
                    if (!insideDependencies) continue;
                    String name = currLine.trim().replaceFirst(" ", AT);
                    name = name.replaceAll("\"", "");
                    childrenMap.put(name, dependencyInfo);
                    continue;
                }
                String[] split = currLine.split(", ");
                for (int i = 0; i < split.length; ++i) {
                    String name = split[i].substring(0, split[i].length() - (split[i].endsWith(":") ? 1 : 0));
                    name = name.replaceAll("\"", "");
                    String groupId = name.split(AT)[name.startsWith(AT) ? 1 : 0];
                    if (i == 0) {
                        dependencyInfo = new DependencyInfo();
                        dependencyInfo.setGroupId(groupId);
                        dependencyInfo.setDependencyType(DependencyType.NPM);
                        String pathToPackageJson = yarnLock.getParent() + this.fileSeparator + NODE_MODULES + this.fileSeparator + groupId + this.fileSeparator + PACKAGE_JSON;
                        dependencyInfo.setSystemPath(pathToPackageJson);
                        dependencyInfo.setFilename(pathToPackageJson);
                    }
                    if (parentsMap.get(name) != null || !this.includeDevDependencies && (this.includeDevDependencies || this.devDependencies.get(groupId) != null && this.devDependencies.get(groupId).equals(name.split(AT)[1]))) continue;
                    parentsMap.put(name, dependencyInfo);
                }
            }
            for (String child : childrenMap.keySet()) {
                if (parentsMap.get(child) == null || this.isDescendant((DependencyInfo)parentsMap.get(child), (DependencyInfo)childrenMap.get(child))) continue;
                ((DependencyInfo)childrenMap.get(child)).getChildren().add(parentsMap.get(child));
            }
            for (String parent : parentsMap.keySet()) {
                if (childrenMap.get(parent) != null) continue;
                dependencyInfos.add((DependencyInfo)parentsMap.get(parent));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    this.logger.error("can't close {}: {}", (Object)yarnLock.getPath(), (Object)e.getMessage());
                }
            }
        }
        return dependencyInfos;
    }

    private boolean isDescendant(DependencyInfo ancestor, DependencyInfo descendant) {
        for (DependencyInfo child : ancestor.getChildren()) {
            if (child.equals((Object)descendant)) {
                return true;
            }
            if (!this.isDescendant(child, descendant)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> findDevDependencies(String folder) {
        Map<String, Object> devDependenciesMap = new HashMap<String, Object>();
        File packageJson = new File(folder + this.fileSeparator + PACKAGE_JSON);
        if (packageJson.isFile()) {
            try {
                FileInputStream is = new FileInputStream(packageJson.getPath());
                String jsonText = IOUtils.toString((InputStream)is, (String)"UTF-8");
                JSONObject json = new JSONObject(jsonText);
                devDependenciesMap = json.getJSONObject(DEV_DEPENDENCIES).toMap();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return devDependenciesMap;
    }
}

