/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.nuget;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetConfigFileType;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetPackagesConfigXmlParser;

public class NugetDependencyResolver
extends AbstractDependencyResolver {
    private final Logger logger = LoggerFactory.getLogger(NugetDependencyResolver.class);
    public static final String CONFIG = ".config";
    public static final String CSPROJ = ".csproj";
    private final String whitesourceConfiguration;
    private final String bomPattern;
    private final NugetConfigFileType nugetConfigFileType;

    public NugetDependencyResolver(String whitesourceConfiguration, NugetConfigFileType nugetConfigFileType) {
        this.whitesourceConfiguration = whitesourceConfiguration;
        this.nugetConfigFileType = nugetConfigFileType;
        this.bomPattern = this.nugetConfigFileType == NugetConfigFileType.CONFIG_FILE_TYPE ? "**/*.config" : "**/*.csproj";
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> configFiles) {
        return this.getResolutionResultFromParsing(topLevelFolder, configFiles, false);
    }

    protected ResolutionResult getResolutionResultFromParsing(String topLevelFolder, Set<String> configFiles, boolean onlyDependenciesFromReferenceTag) {
        Collection<DependencyInfo> dependencies = this.parseNugetPackageFiles(configFiles, onlyDependenciesFromReferenceTag);
        return new ResolutionResult(dependencies, new LinkedList<String>(), this.getDependencyType(), topLevelFolder);
    }

    @Override
    protected Collection<String> getExcludes() {
        LinkedList<String> excludes = new LinkedList<String>();
        excludes.add("whitesource-fs-agent.config");
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return new ArrayList<String>(Arrays.asList(".dll", ".exe", ".nupkg", ".cs"));
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.NUGET;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.NUGET.name();
    }

    @Override
    protected String[] getBomPattern() {
        return new String[]{this.bomPattern};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new ArrayList<String>();
    }

    protected Collection<DependencyInfo> parseNugetPackageFiles(Set<String> configFilesPath, boolean getDependenciesFromReferenceTag) {
        HashSet<DependencyInfo> dependencies = new HashSet<DependencyInfo>();
        for (String configFilePath : configFilesPath) {
            NugetPackagesConfigXmlParser parser;
            Set<DependencyInfo> dependenciesFromSingleFile;
            File configFile;
            if (this.whitesourceConfiguration != null && new File(this.whitesourceConfiguration).getAbsolutePath().equals(configFilePath) || (configFile = new File(configFilePath)).getName().equals("whitesource-fs-agent.config") || (dependenciesFromSingleFile = (parser = new NugetPackagesConfigXmlParser(configFile, this.nugetConfigFileType)).parsePackagesConfigFile(getDependenciesFromReferenceTag, configFilePath)).isEmpty()) continue;
            dependencies.addAll(dependenciesFromSingleFile);
        }
        return dependencies;
    }
}

