/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.packageManger;

import com.aragost.javahg.log.Logger;
import com.aragost.javahg.log.LoggerFactory;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.dependency.resolver.packageManger.LinuxPkgManagerCommand;

public class PackageManagerExtractor {
    private final Logger logger = LoggerFactory.getLogger(PackageManagerExtractor.class);
    private static final int DEBIAN_PACKAGE_NAME_INDEX = 0;
    private static final int DEBIAN_PACKAGE_VERSION_INDEX = 1;
    private static final int DEBIAN_PACKAGE_ARCH_INDEX = 2;
    private static final String DEBIAN_INSTALLED_PACKAGE_PREFIX = "ii";
    private static final String DEBIAN_PACKAGE_PATTERN = "{0}_{1}_{2}.deb";
    private static final String RPM_PACKAGE_PATTERN = "{0}.rpm";
    private static final String ALPINE_PACKAGE_PATTERN = "{0}.apk";
    private static final String ALPINE_PACKAGE_SPLIT_PATTERN = " - ";
    private static final String ARCH_LINUX_PACKAGE_PATTERN = "{0}-{1}-{2}.pkg.tar.xz";
    private static final List<String> SYSTEM_ARCHITECTURES = Arrays.asList("x86_64", "i686", "any");
    private static final String ARCH_LINUX_PACKAGE_SPLIT_PATTERN = " ";
    private static final String NEW_LINE = "\\r?\\n";
    private static final String NON_ASCII_CHARS = "[^\\x20-\\x7e]";
    private static final String ARCH_LINUX_ARCHITECTURE_COMMAND = "uname -m";

    public Collection<AgentProjectInfo> createProjects() {
        LinkedList<Object> packages = new LinkedList<DependencyInfo>();
        LinkedList<AgentProjectInfo> projectInfos = new LinkedList<AgentProjectInfo>();
        InputStream inputStream = null;
        byte[] bytes = null;
        Process process = null;
        this.logger.info("File System Agent is resolving package manger dependencies only");
        for (LinuxPkgManagerCommand linuxPkgManagerCommand : LinuxPkgManagerCommand.values()) {
            try {
                this.logger.debug("Trying to run command {}", new Object[]{linuxPkgManagerCommand.getCommand()});
                process = Runtime.getRuntime().exec(linuxPkgManagerCommand.getCommand());
                inputStream = process.getInputStream();
                if (inputStream.read() == -1) {
                    this.logger.error("Unable to execute - {} , unix flavor does not support this command ", new Object[]{linuxPkgManagerCommand.getCommand()});
                } else {
                    bytes = ByteStreams.toByteArray((InputStream)inputStream);
                    this.logger.info("Succeed to run the command - {} ", new Object[]{linuxPkgManagerCommand.getCommand()});
                    switch (linuxPkgManagerCommand) {
                        case DEBIAN: {
                            this.logger.debug("Getting Debian installed Packages");
                            this.createDebianProject(bytes, packages);
                            break;
                        }
                        case RPM: {
                            this.logger.debug("Getting RPM installed Packages");
                            this.createRpmProject(bytes, packages);
                            break;
                        }
                        case ARCH_LINUX: {
                            this.logger.debug("Getting Arch Linux installed Packages");
                            this.createArchLinuxProject(bytes, packages);
                            break;
                        }
                        case ALPINE: {
                            this.logger.debug("Getting Alpine installed Packages");
                            this.createAlpineProject(bytes, packages);
                            break;
                        }
                    }
                }
                if (packages.size() > 0) {
                    this.logger.debug("Creating new AgentProjectInfo object");
                    AgentProjectInfo projectInfo = new AgentProjectInfo();
                    projectInfo.setDependencies(packages);
                    projectInfos.add(projectInfo);
                    packages = new LinkedList();
                    continue;
                }
                this.logger.info("Couldn't find unix package manager dependencies");
            }
            catch (IOException e) {
                this.logger.warn("Couldn't resolve : {}", new Object[]{linuxPkgManagerCommand.name()});
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.error("InputStream exception : {}", new Object[]{e.getMessage()});
        }
        return projectInfos;
    }

    public void createDebianProject(byte[] bytes, List<DependencyInfo> packages) {
        String[] lines;
        this.logger.info("Trying to resolve debian packages");
        String linesStr = new String(bytes);
        for (String line : lines = linesStr.split(NEW_LINE)) {
            String version;
            if (!(line = line.replaceAll(NON_ASCII_CHARS, "")).startsWith(DEBIAN_INSTALLED_PACKAGE_PREFIX)) continue;
            ArrayList<String> args = new ArrayList<String>();
            for (String s : line.split(ARCH_LINUX_PACKAGE_SPLIT_PATTERN)) {
                if (!StringUtils.isNotBlank((String)s) || s.equals(DEBIAN_INSTALLED_PACKAGE_PREFIX)) continue;
                args.add(s);
            }
            if (args.size() < 3) continue;
            String name = (String)args.get(0);
            if (name.contains(":")) {
                name = name.substring(0, name.indexOf(":"));
            }
            if ((version = (String)args.get(1)).contains(":")) {
                version = version.substring(version.indexOf(":") + 1);
            }
            String arch = (String)args.get(2);
            packages.add(new DependencyInfo(null, MessageFormat.format(DEBIAN_PACKAGE_PATTERN, name, version, arch), version));
        }
    }

    public void createRpmProject(byte[] bytes, List<DependencyInfo> packages) {
        String[] lines;
        this.logger.info("Trying to resolve RPM packages");
        String linesStr = new String(bytes);
        for (String line : lines = linesStr.split(NEW_LINE)) {
            if (!StringUtils.isNotBlank((String)line)) continue;
            packages.add(new DependencyInfo(null, MessageFormat.format(RPM_PACKAGE_PATTERN, line), null));
        }
    }

    public void createArchLinuxProject(byte[] bytes, List<DependencyInfo> packages) {
        this.logger.info("Trying to resolve Arch Linux packages");
        String linesStr = new String(bytes);
        String[] lines = linesStr.split(NEW_LINE);
        String arch = this.getSystemArchitecture();
        if (StringUtils.isNotBlank((String)arch)) {
            for (String line : lines) {
                line = line.replaceAll(NON_ASCII_CHARS, "");
                String[] split = line.split(ARCH_LINUX_PACKAGE_SPLIT_PATTERN);
                this.logger.info(split[0]);
                if (split.length != 2) continue;
                packages.add(new DependencyInfo(null, MessageFormat.format(ARCH_LINUX_PACKAGE_PATTERN, split[0], split[1], arch), null));
            }
        }
    }

    public void createAlpineProject(byte[] bytes, List<DependencyInfo> packages) {
        String[] lines;
        this.logger.info("Trying to resolve Alpine packages");
        String linesStr = new String(bytes);
        for (String line : lines = linesStr.split(NEW_LINE)) {
            String[] split;
            if (!(line = line.replaceAll(NON_ASCII_CHARS, "")).contains(ALPINE_PACKAGE_SPLIT_PATTERN) || (split = line.split(ALPINE_PACKAGE_SPLIT_PATTERN)).length <= 0) continue;
            packages.add(new DependencyInfo(null, MessageFormat.format(ALPINE_PACKAGE_PATTERN, split[0]), null));
        }
    }

    private String getSystemArchitecture() {
        String arch = "";
        String outputStr = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(ARCH_LINUX_ARCHITECTURE_COMMAND);
            process.waitFor();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            outputStr = bufferedReader.readLine();
            if (StringUtils.isNotBlank((String)outputStr) && SYSTEM_ARCHITECTURES.contains(outputStr)) {
                arch = outputStr;
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            this.logger.warn("Error processing arch linux command {}, error : {}", new Object[]{LinuxPkgManagerCommand.ARCH_LINUX, e.getMessage()});
        }
        catch (InterruptedException e) {
            this.logger.warn("Error InterruptedException {}, error : {}", new Object[]{LinuxPkgManagerCommand.ARCH_LINUX, e.getMessage()});
        }
        return arch;
    }
}

