/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.paket;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.hash.ChecksumUtils;

abstract class AbstractPaketDependencyCollector
extends DependencyCollector {
    private final Logger logger = LoggerFactory.getLogger(AbstractPaketDependencyCollector.class);
    private static final String FOUR_SPACES = "    ";
    private static final String SIX_SPACES = "      ";
    private static final String NUPKG = "nupkg";
    private static final String PAKET_LOCK = "paket.lock";
    private static final String NUGET = "NUGET";
    private static final String RIGHT_BRACKET = ")";
    private String[] paketIgnoredGroups;
    private String rootDirectory;
    private List<String> directDependenciesNames;

    public AbstractPaketDependencyCollector(List<String> directDependenciesNames, String[] paketIgnoredGroups) {
        this.directDependenciesNames = directDependenciesNames;
        this.paketIgnoredGroups = paketIgnoredGroups;
    }

    @Override
    public Collection<AgentProjectInfo> collectDependencies(String rootDirectory) {
        this.rootDirectory = rootDirectory;
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        if (!(this.paketIgnoredGroups != null && Arrays.asList(this.paketIgnoredGroups).contains(this.getGroupName().toLowerCase()) || this.directDependenciesNames.isEmpty())) {
            List<String> groupLines = this.getGroupDependenciesFromPaketLock();
            for (String dependencyName : this.directDependenciesNames) {
                DependencyInfo dependency = new DependencyInfo();
                dependency.setGroupId(dependencyName);
                dependencies.add(dependency);
                dependency.setChildren(this.collectChildrenDependencies(dependency, groupLines));
            }
        }
        return this.getSingleProjectList(dependencies);
    }

    private Collection<DependencyInfo> collectChildrenDependencies(DependencyInfo dependency, List<String> groupLines) {
        this.logger.debug("Collect child dependencies of {}", (Object)dependency.getGroupId());
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        boolean dependencyLine = false;
        for (String line : groupLines) {
            if (!dependencyLine && line.startsWith(FOUR_SPACES + dependency.getGroupId() + " ")) {
                dependencyLine = true;
                this.getDependencyFromLine(dependency, line);
                continue;
            }
            if (!dependencyLine) continue;
            if (!line.startsWith(SIX_SPACES)) break;
            DependencyInfo childDependency = new DependencyInfo();
            String lineWithoutSpaces = line.substring(SIX_SPACES.length());
            childDependency.setGroupId(lineWithoutSpaces.substring(0, lineWithoutSpaces.indexOf(" ")));
            childDependency.setChildren(this.collectChildrenDependencies(childDependency, groupLines));
            dependencies.add(childDependency);
        }
        return dependencies;
    }

    private void getDependencyFromLine(DependencyInfo dependency, String line) {
        String beginOfVersion = line.substring(line.indexOf(dependency.getGroupId()) + dependency.getGroupId().length() + 2);
        String version = beginOfVersion.substring(0, beginOfVersion.indexOf(RIGHT_BRACKET));
        File dependencyFile = this.findFileFromPath(dependency.getGroupId(), version);
        String sha1 = this.getPackageSha1(dependencyFile, dependency.getGroupId(), version);
        String systemPath = "";
        if (dependencyFile != null) {
            systemPath = dependencyFile.getAbsolutePath();
        }
        this.updateDependencyInfo(dependency, dependency.getGroupId(), version, sha1, systemPath);
    }

    private File findFileFromPath(String dependencyName, String dependencyVersion) {
        String path = this.getFolderPathOfDependency(dependencyName);
        File folder = new File(path);
        File dependencyFile = null;
        String dependencyNameLowerCase = dependencyName.toLowerCase();
        String dependencyVersionLowerCase = dependencyVersion.toLowerCase();
        if (folder.exists()) {
            for (File file : folder.listFiles()) {
                if (!file.getName().toLowerCase().startsWith(dependencyNameLowerCase + "." + dependencyVersionLowerCase) || !file.getName().endsWith(".nupkg")) continue;
                dependencyFile = file;
                break;
            }
        }
        return dependencyFile;
    }

    private void updateDependencyInfo(DependencyInfo dependency, String name, String version, String sha1, String systemPath) {
        if (!StringUtils.isEmpty((Object)systemPath)) {
            dependency.setSystemPath(systemPath);
        }
        if (StringUtils.isEmpty((Object)sha1)) {
            dependency.setGroupId(name);
            dependency.setArtifactId(name);
            dependency.setVersion(version);
            dependency.setDependencyType(DependencyType.NUGET);
        } else {
            dependency.setGroupId(name);
            dependency.setArtifactId(new File(systemPath).getName());
            dependency.setSha1(sha1);
        }
    }

    private List<String> getGroupDependenciesFromPaketLock() {
        LinkedList<String> result = new LinkedList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.rootDirectory + "/" + PAKET_LOCK));){
            String line;
            boolean rightGroup = false;
            boolean nugetSection = false;
            while ((line = bufferedReader.readLine()) != null) {
                if (!rightGroup && line.startsWith(this.beginGroupLine())) {
                    rightGroup = true;
                }
                if (!rightGroup) continue;
                if (!nugetSection && line.startsWith(NUGET)) {
                    nugetSection = true;
                    continue;
                }
                if (!nugetSection) continue;
                if (line.startsWith(" ")) {
                    result.add(line);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed reading paket.lock file in {}. Consider executing 'paket install' first.", (Object)this.rootDirectory);
        }
        return result;
    }

    protected abstract String getGroupName();

    protected abstract String beginGroupLine();

    protected abstract String getFolderPathOfDependency(String var1);

    protected String getPackagesFolder() {
        return this.rootDirectory + "/" + "packages";
    }

    protected String getPackageSha1(File calcSha1File, String dependencyName, String dependencyVersion) {
        String sha1 = "";
        if (calcSha1File != null) {
            try {
                sha1 = ChecksumUtils.calculateSHA1((File)calcSha1File);
            }
            catch (IOException e) {
                this.logger.warn("Failed getting " + calcSha1File.getAbsolutePath() + ". Could not calculate sha1 for this file.");
                this.logger.debug("Error calculating sha1: {}", (Object)e.getMessage());
            }
        } else {
            this.logger.warn("{} folder is not exist. Could not calculate sha1 for {} - {}.", new Object[]{this.getFolderPathOfDependency(dependencyName), dependencyName, dependencyVersion});
        }
        return sha1;
    }
}

