/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.ruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.ruby.GemFileNameFilter;
import org.whitesource.agent.dependency.resolver.ruby.RubyCli;
import org.whitesource.agent.hash.ChecksumUtils;

public class RubyDependencyResolver
extends AbstractDependencyResolver {
    private static final String GEM_FILE_LOCK = "Gemfile.lock";
    private static final String ORIG = ".orig";
    private static final List<String> RUBY_SCRIPT_EXTENSION = Arrays.asList(".rb");
    private static final String BUNDLE = "bundle";
    private static final String ENVIRONMENT = "environment gemdir";
    private static final char TILDE = '~';
    protected static final String GEM = "gem";
    protected static final String REGEX = "\\S";
    protected static final String SPECS = "specs:";
    protected static final String CACHE = "cache";
    protected static final String V = "-v";
    protected static final String ERROR = "ERROR";
    protected static final String MINGW = "mingw";
    private final Logger logger = LoggerFactory.getLogger(RubyDependencyResolver.class);
    private RubyCli cli = new RubyCli();
    private boolean runBundleInstall;
    private boolean overwriteGemFile;
    private boolean installMissingGems;
    private String rootDirectory;

    public RubyDependencyResolver(boolean runBundleInstall, boolean overwriteGemFile, boolean installMissingGems) {
        this.runBundleInstall = runBundleInstall;
        this.overwriteGemFile = overwriteGemFile;
        this.installMissingGems = installMissingGems;
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        this.rootDirectory = topLevelFolder;
        List<DependencyInfo> dependencies = this.collectDependencies();
        return new ResolutionResult(dependencies, this.getExcludes(), this.getDependencyType(), topLevelFolder);
    }

    @Override
    protected Collection<String> getExcludes() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("**/*" + RUBY_SCRIPT_EXTENSION);
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return RUBY_SCRIPT_EXTENSION;
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.RUBY;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.RUBY.name();
    }

    @Override
    protected String[] getBomPattern() {
        return new String[]{"**/*Gemfile.lock"};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return null;
    }

    private List<DependencyInfo> collectDependencies() {
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        File gemFileLock = new File(this.rootDirectory + fileSeparator + GEM_FILE_LOCK);
        File gemFileLockOrig = new File(this.rootDirectory + fileSeparator + GEM_FILE_LOCK + ORIG);
        if (this.runBundleInstall) {
            this.runBundleInstall(gemFileLock, gemFileLockOrig);
        }
        if (gemFileLock.isFile()) {
            this.parseGemFileLock(gemFileLock, dependencyInfos);
        } else {
            this.logger.warn("Can't scan Gemlock.file - not found");
        }
        if (gemFileLockOrig.isFile()) {
            this.removeTempFile(gemFileLock, gemFileLockOrig);
        }
        return dependencyInfos;
    }

    private boolean runBundleInstall(File gemFileLock, File origGemFileLock) {
        boolean bundleInstallSuccess;
        if (!this.overwriteGemFile && gemFileLock.isFile()) {
            gemFileLock.renameTo(origGemFileLock);
        }
        boolean bl = bundleInstallSuccess = this.cli.runCmd(this.rootDirectory, this.cli.getCommandParams(BUNDLE, "install")) != null && gemFileLock.isFile();
        if (!bundleInstallSuccess && !this.overwriteGemFile) {
            origGemFileLock.renameTo(gemFileLock);
        }
        return bundleInstallSuccess;
    }

    private void removeTempFile(File gemFileLock, File origGemFileLock) {
        if (origGemFileLock.isFile()) {
            try {
                FileUtils.forceDelete((File)gemFileLock);
                origGemFileLock.renameTo(gemFileLock);
            }
            catch (IOException e) {
                this.logger.warn("can't remove {}: {}", (Object)gemFileLock.getPath(), (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGemFileLock(File gemLockFile, List<DependencyInfo> dependencyInfos) {
        String pathToGems = null;
        try {
            pathToGems = this.findPathToGems();
            if (pathToGems == null) {
                this.logger.warn("Can't find path to gems' cache folder");
                return;
            }
        }
        catch (FileNotFoundException e) {
            this.logger.warn("Can't find path to gems' cache folder {}", (Object)e.getMessage());
            return;
        }
        FileReader fileReader = null;
        try {
            String currLine;
            fileReader = new FileReader(gemLockFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            boolean insideGem = false;
            boolean insideSpecs = false;
            Pattern pattern = Pattern.compile(REGEX);
            Integer previousIndex = 0;
            boolean indented = false;
            DependencyInfo dependencyInfo = null;
            LinkedList<DependencyInfo> parentsList = new LinkedList<DependencyInfo>();
            LinkedList<DependencyInfo> childrenList = new LinkedList<DependencyInfo>();
            LinkedList<DependencyInfo> partialDependencies = new LinkedList<DependencyInfo>();
            DependencyInfo parentDependency = null;
            block23: while ((currLine = bufferedReader.readLine()) != null) {
                if (insideGem && insideSpecs) {
                    String name;
                    if (currLine.isEmpty()) break;
                    Matcher matcher = pattern.matcher(currLine);
                    if (!matcher.find()) continue;
                    int index = matcher.start();
                    if (index > previousIndex && previousIndex > 0 || indented && index == previousIndex) {
                        if (parentDependency == null) continue;
                        indented = true;
                        previousIndex = index;
                        int spaceIndex = currLine.indexOf(" ", index);
                        name = currLine.substring(index, spaceIndex > -1 ? spaceIndex : currLine.length());
                        dependencyInfo = parentsList.stream().filter(d -> d.getGroupId().equals(name)).findFirst().orElse(null);
                        if (dependencyInfo == null && (dependencyInfo = (DependencyInfo)childrenList.stream().filter(d -> d.getGroupId().equals(name)).findFirst().orElse(null)) == null) {
                            dependencyInfo = new DependencyInfo();
                            dependencyInfo.setGroupId(name);
                            int indexOfOpenBracket = currLine.indexOf(40);
                            int indexOfCloseBracket = currLine.indexOf(41);
                            if (indexOfOpenBracket != -1 && indexOfCloseBracket != -1) {
                                String version = currLine.substring(currLine.indexOf(40) + 1, currLine.indexOf(41));
                                int indexSeparator = version.indexOf(",");
                                if (indexSeparator != -1) {
                                    version = version.substring(0, indexSeparator);
                                }
                                if (version.charAt(0) == '~') {
                                    dependencyInfo.setVersion(version.substring(3));
                                } else {
                                    dependencyInfo.setVersion(version);
                                }
                            }
                            if (!partialDependencies.contains(dependencyInfo)) {
                                partialDependencies.add(dependencyInfo);
                            }
                        }
                        parentDependency.getChildren().add(dependencyInfo);
                        for (DependencyInfo d2 : childrenList) {
                            if (!d2.equals((Object)dependencyInfo)) continue;
                            continue block23;
                        }
                        childrenList.add(dependencyInfo);
                        continue;
                    }
                    String[] split = currLine.trim().split(" ");
                    name = split[0];
                    String version = split[1].substring(1, split[1].length() - 1);
                    try {
                        String sha1 = this.getRubyDependenciesSha1(name, version, pathToGems);
                        if (sha1 == null) {
                            this.logger.warn("Can't find gem file for {}-{}", (Object)name, (Object)version);
                            continue;
                        }
                        dependencyInfo = childrenList.stream().filter(d -> d.getGroupId().equals(name)).findFirst().orElse(null);
                        if (dependencyInfo == null) {
                            dependencyInfo = new DependencyInfo(sha1);
                            dependencyInfo.setGroupId(name);
                        } else {
                            dependencyInfo.setSha1(sha1);
                        }
                        partialDependencies.remove(dependencyInfo);
                        this.setDependencyInfoProperties(dependencyInfo, name, version, gemLockFile, pathToGems);
                        parentsList.add(dependencyInfo);
                        parentDependency = dependencyInfo;
                        continue;
                    }
                    catch (IOException e) {
                        this.logger.warn("Can't find gem file for {}-{}", (Object)name, (Object)version);
                        continue;
                    }
                    finally {
                        indented = false;
                        previousIndex = index;
                        continue;
                    }
                }
                if (currLine.contains(GEM.toUpperCase())) {
                    insideGem = true;
                    continue;
                }
                if (!insideGem || !currLine.contains(SPECS)) continue;
                insideSpecs = true;
            }
            for (DependencyInfo parent : parentsList) {
                boolean foundChild = false;
                for (DependencyInfo child : childrenList) {
                    if (!parent.equals((Object)child)) continue;
                    foundChild = true;
                    break;
                }
                if (foundChild) continue;
                dependencyInfos.add(parent);
            }
            for (DependencyInfo partialDependency : partialDependencies) {
                char firstChar;
                String version = this.findGemVersion(partialDependency.getGroupId(), pathToGems);
                String versionToCompare = null;
                if (partialDependency.getVersion() != null && ((firstChar = partialDependency.getVersion().charAt(0)) == '>' || firstChar == '=')) {
                    versionToCompare = partialDependency.getVersion().substring(3);
                }
                if (version == null || versionToCompare != null && RubyDependencyResolver.versionCompare(versionToCompare, version) > 0) {
                    List<String> lines = this.installGem(partialDependency.getGroupId(), "'" + partialDependency.getVersion() + "'");
                    if (lines != null) {
                        File file = this.findMaxVersionFile(partialDependency.getGroupId(), pathToGems);
                        if (file != null) {
                            String sha1 = ChecksumUtils.calculateSHA1((File)file);
                            this.fillDependency(sha1, partialDependency, this.getVersionFromFileName(file.getName(), partialDependency.getGroupId()), gemLockFile, pathToGems, dependencyInfos);
                            continue;
                        }
                        this.logger.warn("Can't find version for {}-{}", (Object)partialDependency.getGroupId());
                        this.removeChildren(dependencyInfos, partialDependency);
                        continue;
                    }
                    this.logger.warn("Can't find version for {}-{}", (Object)partialDependency.getGroupId());
                    this.removeChildren(dependencyInfos, partialDependency);
                    continue;
                }
                String sha1 = this.getRubyDependenciesSha1(partialDependency.getGroupId(), version, pathToGems);
                this.fillDependency(sha1, partialDependency, version, gemLockFile, pathToGems, dependencyInfos);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.warn("Could not find Gemfile.lock {}", (Object)e.getMessage());
            this.logger.debug("stacktrace {}", (Object[])e.getStackTrace());
        }
        catch (Exception e) {
            this.logger.warn("Could not parse Gemfile.lock {}", (Object)e.getMessage());
            this.logger.debug("stacktrace {}", (Object[])e.getStackTrace());
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException e) {
                this.logger.warn("Can't close Gemfile.lock {}", (Object)e.getMessage());
                this.logger.debug("stacktrace {}", (Object[])e.getStackTrace());
            }
        }
    }

    private void fillDependency(String sha1, DependencyInfo partialDependency, String version, File gemLockFile, String pathToGems, List<DependencyInfo> dependencyInfos) {
        if (sha1 == null) {
            this.logger.warn("Can't find gem file for {}-{}", (Object)partialDependency.getGroupId(), (Object)version);
            this.removeChildren(dependencyInfos, partialDependency);
        } else {
            partialDependency.setSha1(sha1);
            this.setDependencyInfoProperties(partialDependency, partialDependency.getGroupId(), version, gemLockFile, pathToGems);
        }
    }

    public static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    private void removeChildren(Collection<DependencyInfo> dependencyInfos, DependencyInfo child) {
        Iterator<DependencyInfo> iterator = dependencyInfos.iterator();
        while (iterator.hasNext()) {
            DependencyInfo dependencyInfo = iterator.next();
            if (dependencyInfo.getChildren().size() > 0) {
                this.removeChildren(dependencyInfo.getChildren(), child);
                continue;
            }
            if (!dependencyInfo.equals((Object)child)) continue;
            iterator.remove();
        }
    }

    private void setDependencyInfoProperties(DependencyInfo dependencyInfo, String name, String version, File gemLockFile, String pathToGems) {
        dependencyInfo.setArtifactId(name + "-" + version + "." + GEM);
        dependencyInfo.setVersion(version);
        dependencyInfo.setDependencyType(DependencyType.RUBY);
        dependencyInfo.setSystemPath(gemLockFile.getPath());
        dependencyInfo.setFilename(pathToGems + fileSeparator + name + "-" + version + "." + GEM);
    }

    private String findPathToGems() throws FileNotFoundException {
        String[] commandParams = this.cli.getCommandParams(GEM, ENVIRONMENT);
        List<String> lines = this.cli.runCmd(this.rootDirectory, commandParams);
        String path = null;
        if (lines != null && !new File(path = lines.get(0) + fileSeparator + CACHE).isDirectory()) {
            throw new FileNotFoundException();
        }
        return path;
    }

    private String getRubyDependenciesSha1(String name, String version, String pathToGems) throws IOException {
        String sha1 = null;
        File file = new File(pathToGems + fileSeparator + name + "-" + version + "." + GEM);
        if (file.isFile()) {
            sha1 = ChecksumUtils.calculateSHA1((File)file);
        } else if ((file = this.installMissingGem(name, version, file)) != null) {
            sha1 = ChecksumUtils.calculateSHA1((File)file);
        }
        return sha1;
    }

    private File installMissingGem(String name, String version, File file) {
        if (this.installMissingGems) {
            this.logger.info("installing gem file for {}-{}", (Object)name, (Object)version);
            if (version.toLowerCase().contains(MINGW)) {
                version = version.substring(0, version.indexOf("-"));
            }
            List<String> lines = this.installGem(name, version);
            if (file.isFile()) {
                return file;
            }
            if (lines != null) {
                List errors = lines.stream().filter(line -> line.startsWith(ERROR)).collect(Collectors.toList());
                if (errors.size() > 0) {
                    return null;
                }
                try {
                    String installed = lines.stream().filter(line -> line.startsWith("Successfully installed") && line.contains(name)).findFirst().orElse("");
                    String gem = installed.split(" ")[2];
                    File newFile = new File(file.getParent() + fileSeparator + gem + "." + GEM);
                    if (newFile.isFile()) {
                        return newFile;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    this.logger.warn("failed installing gem file for {}-{}", (Object)name, (Object)version);
                    this.logger.debug("stacktrace {}", (Object[])e.getStackTrace());
                }
            }
        }
        return null;
    }

    private List<String> installGem(String name, String version) {
        String param = "install".concat(" " + name + " " + V + " " + version);
        String[] commandParams = this.cli.getCommandParams(GEM, param);
        return this.cli.runCmd(this.rootDirectory, commandParams);
    }

    private String findGemVersion(String gemName, String pathToGems) {
        String version = null;
        File maxVersionFile = this.findMaxVersionFile(gemName, pathToGems);
        if (maxVersionFile != null) {
            String fileName = maxVersionFile.getName();
            version = this.getVersionFromFileName(fileName, gemName);
        }
        return version;
    }

    private String getVersionFromFileName(String fileName, String gemName) {
        return fileName.substring(gemName.length() + 1, fileName.lastIndexOf("."));
    }

    private File findMaxVersionFile(String gemName, String pathToGems) {
        File gemsFolder = new File(pathToGems);
        File[] files = gemsFolder.listFiles(new GemFileNameFilter(gemName));
        if (files.length > 0) {
            Arrays.sort(files, Collections.reverseOrder());
            return files[0];
        }
        return null;
    }
}

