/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.utils.FilesScanner;

public class FilesUtils {
    private final Logger logger = LoggerFactory.getLogger(FilesUtils.class);
    private final String JAVA_TEMP_DIR = System.getProperty("java.io.tmpdir");

    public String createTmpFolder(boolean addCharToEndOfUrl, String nameOfFolder) {
        String result = this.getTempDirPackages(addCharToEndOfUrl, nameOfFolder);
        try {
            FileUtils.forceMkdir((File)new File(result));
        }
        catch (IOException e) {
            this.logger.warn("Failed to create temp folder : " + e.getMessage());
            result = null;
        }
        return result;
    }

    private String getTempDirPackages(boolean addCharToEndOfUrl, String nameOfFolder) {
        String tempFolder;
        String creationDate = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String string = tempFolder = this.JAVA_TEMP_DIR.endsWith(File.separator) ? this.JAVA_TEMP_DIR + nameOfFolder + File.separator + creationDate : this.JAVA_TEMP_DIR + File.separator + nameOfFolder + File.separator + creationDate;
        if (addCharToEndOfUrl) {
            tempFolder = tempFolder + "1";
        }
        return tempFolder;
    }

    public List<Path> getSubDirectories(String directory, String[] includes, String[] excludesExtended, boolean followSymlinks, boolean globCaseSensitive) {
        String[] files;
        FilesScanner filesScanner = new FilesScanner();
        try {
            files = filesScanner.getDirectoryContent(directory, includes, excludesExtended, followSymlinks, globCaseSensitive, true);
        }
        catch (Exception ex) {
            this.logger.info("Error getting sub directories from: " + directory, (Object)ex.getMessage());
            files = new String[]{};
        }
        return Arrays.stream(files).map(subDir -> Paths.get(directory, subDir)).collect(Collectors.toList());
    }

    public Map<File, Collection<String>> fillFilesMap(Collection<String> pathsToScan, String[] includes, String[] excludesExtended, boolean followSymlinks, boolean globCaseSensitive) {
        HashMap<File, Collection<String>> fileMap = new HashMap<File, Collection<String>>();
        for (String scannerBaseDir : pathsToScan) {
            File file = new File(scannerBaseDir);
            this.logger.debug("Scanning {}", (Object)file.getAbsolutePath());
            if (file.exists()) {
                FilesScanner filesScanner = new FilesScanner();
                if (file.isDirectory()) {
                    File basedir = new File(scannerBaseDir);
                    String[] fileNames = filesScanner.getDirectoryContent(scannerBaseDir, includes, excludesExtended, followSymlinks, globCaseSensitive);
                    List fileNameList = Arrays.stream(fileNames).collect(Collectors.toList());
                    fileMap.put(basedir, fileNameList);
                    continue;
                }
                boolean included = filesScanner.isIncluded(file, includes, excludesExtended, followSymlinks, globCaseSensitive);
                if (!included) continue;
                ArrayList<String> files = (ArrayList<String>)fileMap.get(file.getParentFile());
                if (files == null) {
                    files = new ArrayList<String>();
                }
                files.add(file.getName());
                fileMap.put(file.getParentFile(), files);
                continue;
            }
            this.logger.info(MessageFormat.format("File {0} doesn't exist", scannerBaseDir));
        }
        return fileMap;
    }

    public static void deleteDirectory(File directory) {
        if (directory != null) {
            try {
                FileUtils.forceDelete((File)directory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        String extension = "";
        int i = fileName.lastIndexOf(".");
        if (i > 0 && i < fileName.length() - 2) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }
}

