/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

public class MemoryUsageHelper {
    public static SystemStats getMemoryUsage() {
        long mbRatio = 0x100000L;
        Runtime runTime = Runtime.getRuntime();
        return new SystemStats(runTime.availableProcessors(), runTime.freeMemory() / mbRatio, runTime.maxMemory() / mbRatio, runTime.totalMemory() / mbRatio, (runTime.totalMemory() - runTime.freeMemory()) / mbRatio);
    }

    public static class SystemStats {
        int availableProcessors;
        long freeMemory;
        long maxMemory;
        long totalMemory;
        long usedMemory;

        private SystemStats(int availableProcessors, long freeMemory, long maxMemory, long totalMemory, long usedMemory) {
            this.availableProcessors = availableProcessors;
            this.freeMemory = freeMemory;
            this.maxMemory = maxMemory;
            this.totalMemory = totalMemory;
            this.usedMemory = usedMemory;
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public long getUsedMemory() {
            return this.usedMemory;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Available processors (cores): \t" + this.getAvailableProcessors());
            sb.append(System.lineSeparator());
            sb.append("Free memory (Mb): \t" + this.getFreeMemory());
            sb.append(System.lineSeparator());
            sb.append("Max memory (Mb): \t" + (this.getMaxMemory() == 0x7FFFFFFFFFFL ? "no limit" : Long.valueOf(this.getMaxMemory())));
            sb.append(System.lineSeparator());
            sb.append("Total memory (Mb): \t" + this.getTotalMemory());
            sb.append(System.lineSeparator());
            sb.append("Used memory (Mb): \t" + this.getUsedMemory());
            sb.append(System.lineSeparator());
            return sb.toString();
        }
    }
}

