/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.FileSystemScanner;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.fs.ExtensionUtils;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.fs.configuration.ConfigurationSerializer;
import org.whitesource.fs.configuration.ResolverConfiguration;

public class ComponentScan {
    private final Logger logger = LoggerFactory.getLogger(ComponentScan.class);
    private Properties config;

    public ComponentScan(Properties config) {
        this.config = config;
    }

    public String scan() {
        this.logger.info("Starting analysis - component scan has started");
        String directory = this.config.getProperty("d");
        String[] directories = directory.split(",");
        ArrayList<String> scannerBaseDirs = new ArrayList<String>(Arrays.asList(directories));
        if (!scannerBaseDirs.isEmpty()) {
            this.logger.info("Getting properties");
            FSAConfiguration fsaConfiguration = new FSAConfiguration(this.config);
            ResolverConfiguration resolverConfiguration = fsaConfiguration.getResolver();
            String[] includes = this.config.getProperty("includes") != null ? this.config.getProperty("includes").split("[,;\\s]+") : ExtensionUtils.INCLUDES;
            String[] excludes = this.config.getProperty("excludes") != null ? this.config.getProperty("excludes").split("[,;\\s]+") : ExtensionUtils.EXCLUDES;
            String[] acceptExtensionsList = (String[])this.config.get("acceptExtensionsList");
            boolean globCaseSensitive = this.config.getProperty("case.sensitive.glob") != null ? Boolean.valueOf(this.config.getProperty("case.sensitive.glob")) : false;
            boolean followSymlinks = this.config.getProperty("case.sensitive.glob") != null ? Boolean.valueOf(this.config.getProperty("case.sensitive.glob")) : false;
            Collection<String> excludedCopyrights = fsaConfiguration.getAgent().getExcludedCopyrights();
            excludedCopyrights.remove("");
            this.logger.info("Resolving dependencies");
            HashSet<String> setDirs = new HashSet<String>();
            setDirs.addAll(scannerBaseDirs);
            HashMap<String, Set<String>> appPathsToDependencyDirs = new HashMap<String, Set<String>>();
            appPathsToDependencyDirs.put("defaultKey", setDirs);
            Set<AgentProjectInfo> projects = new FileSystemScanner(resolverConfiguration, fsaConfiguration.getAgent(), false).createProjects(scannerBaseDirs, appPathsToDependencyDirs, false, includes, excludes, globCaseSensitive, fsaConfiguration.getAgent().getArchiveExtractionDepth(), fsaConfiguration.getAgent().getArchiveIncludes(), fsaConfiguration.getAgent().getArchiveExcludes(), fsaConfiguration.getAgent().isArchiveFastUnpack(), followSymlinks, excludedCopyrights, fsaConfiguration.getAgent().isPartialSha1Match(), fsaConfiguration.getAgent().isCalculateHints(), fsaConfiguration.getAgent().isCalculateMd5(), fsaConfiguration.getAgent().getPythonRequirementsFileIncludes()).keySet();
            this.logger.info("Finished dependency resolution");
            for (AgentProjectInfo project : projects) {
                project.setProjectToken(" ");
                if (acceptExtensionsList == null || acceptExtensionsList.length <= 0) continue;
                project.setDependencies(this.getDependenciesFromExtensionsListOnly(project.getDependencies(), acceptExtensionsList));
            }
            String jsonString = new ConfigurationSerializer<Set<AgentProjectInfo>>().getAsString(projects, true);
            return jsonString;
        }
        return "";
    }

    private List<DependencyInfo> getDependenciesFromExtensionsListOnly(Collection<DependencyInfo> dependencies, String[] acceptExtensionsList) {
        LinkedList<DependencyInfo> filteredDependencies = new LinkedList<DependencyInfo>();
        block0: for (DependencyInfo dependency : dependencies) {
            for (String extension : acceptExtensionsList) {
                if (dependency.getDependencyType() == null && !dependency.getArtifactId().endsWith("." + extension) && !this.checkFileName(dependency, extension)) continue;
                filteredDependencies.add(dependency);
                dependency.setChildren(this.getDependenciesFromExtensionsListOnly(dependency.getChildren(), acceptExtensionsList));
                continue block0;
            }
        }
        return filteredDependencies;
    }

    private boolean checkFileName(DependencyInfo dependency, String extension) {
        boolean fileNameEndsWithExtension = false;
        if (dependency.getFilename() != null) {
            fileNameEndsWithExtension = dependency.getFilename().endsWith("." + extension);
        }
        return fileNameEndsWithExtension;
    }
}

