/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.FileSystemScanner;
import org.whitesource.agent.ViaComponents;
import org.whitesource.agent.ViaLanguage;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.dependency.resolver.docker.DockerResolver;
import org.whitesource.agent.dependency.resolver.npm.NpmLsJsonDependencyCollector;
import org.whitesource.agent.dependency.resolver.packageManger.PackageManagerExtractor;
import org.whitesource.agent.utils.CommandLineProcess;
import org.whitesource.agent.utils.FilesUtils;
import org.whitesource.agent.utils.Pair;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.fs.ProjectsDetails;
import org.whitesource.fs.StatusCode;
import org.whitesource.fs.configuration.ScmConfiguration;
import org.whitesource.fs.configuration.ScmRepositoriesParser;
import org.whitesource.scm.ScmConnector;

public class FileSystemAgent {
    private Logger logger = LoggerFactory.getLogger(FileSystemAgent.class);
    private static final String NPM_COMMAND = NpmLsJsonDependencyCollector.isWindows() ? "npm.cmd" : "npm";
    private static final String PACKAGE_LOCK = "package-lock.json";
    private static final String PACKAGE_JSON = "package.json";
    private final List<String> dependencyDirs;
    private final FSAConfiguration config;
    private boolean projectPerSubFolder;

    public FileSystemAgent(FSAConfiguration config, List<String> dependencyDirs) {
        this.config = config;
        this.projectPerSubFolder = config.getRequest().isProjectPerSubFolder();
        if (this.projectPerSubFolder) {
            this.dependencyDirs = new LinkedList<String>();
            for (String directory : dependencyDirs) {
                File file = new File(directory);
                if (file.isDirectory()) {
                    List<Path> directories = new FilesUtils().getSubDirectories(directory, config.getAgent().getProjectPerFolderIncludes(), config.getAgent().getProjectPerFolderExcludes(), config.getAgent().isFollowSymlinks(), config.getAgent().getGlobCaseSensitive());
                    directories.forEach(subDir -> this.dependencyDirs.add(subDir.toString()));
                    continue;
                }
                if (file.isFile()) {
                    this.dependencyDirs.add(directory);
                    continue;
                }
                this.logger.warn(directory + "is not a file nor a directory .");
            }
        } else {
            this.dependencyDirs = dependencyDirs;
        }
    }

    public ProjectsDetails createProjects() {
        AgentProjectInfo projectInfo;
        if (this.projectPerSubFolder) {
            if (this.config.getSender().isEnableImpactAnalysis()) {
                this.logger.warn("Could not executing VIA impact analysis with the 'projectPerFolder' flag");
            }
            ProjectsDetails projects = new ProjectsDetails(new ArrayList<AgentProjectInfo>(), StatusCode.SUCCESS, "");
            for (String directory : this.dependencyDirs) {
                HashMap<String, Set<String>> appPathsToDependencyDirs = new HashMap<String, Set<String>>();
                HashSet<String> setDirs = new HashSet<String>();
                setDirs.add(directory);
                appPathsToDependencyDirs.put("defaultKey", setDirs);
                ProjectsDetails projectsDetails = this.getProjects(Collections.singletonList(directory), appPathsToDependencyDirs);
                if (projectsDetails.getProjects().size() == 1) {
                    String projectName = new File(directory).getName();
                    String projectVersion = this.config.getRequest().getProjectVersion();
                    AgentProjectInfo projectInfo2 = projectsDetails.getProjects().stream().findFirst().get();
                    projectInfo2.setCoordinates(new Coordinates(null, projectName, projectVersion));
                    projects.getProjectToViaComponents().put(projectInfo2, projectsDetails.getProjectToViaComponents().get(projectInfo2));
                }
                if (projectsDetails.getStatusCode().equals((Object)StatusCode.SUCCESS)) continue;
                return new ProjectsDetails(new ArrayList<AgentProjectInfo>(), projects.getStatusCode(), projects.getDetails());
            }
            return projects;
        }
        ProjectsDetails projects = this.getProjects(this.dependencyDirs, this.config.getAppPathsToDependencyDirs());
        if (projects.getProjects().size() > 0 && (projectInfo = projects.getProjects().stream().findFirst().get()).getCoordinates() == null) {
            String projectToken = this.config.getRequest().getProjectToken();
            if (StringUtils.isNotBlank((String)projectToken)) {
                projectInfo.setProjectToken(projectToken);
            } else {
                String projectName = this.config.getRequest().getProjectName();
                String projectVersion = this.config.getRequest().getProjectVersion();
                projectInfo.setCoordinates(new Coordinates(null, projectName, projectVersion));
            }
        }
        return projects;
    }

    private ProjectsDetails getProjects(List<String> scannerBaseDirs, Map<String, Set<String>> appPathsToDependencyDirs) {
        ProjectsDetails projectsDetails;
        StatusCode[] success = new StatusCode[]{StatusCode.SUCCESS};
        String separatorFiles = NpmLsJsonDependencyCollector.isWindows() ? "\\" : "/";
        ArrayList scmPaths = new ArrayList();
        boolean[] hasScmConnectors = new boolean[1];
        List<Object> scmConnectors = null;
        if (StringUtils.isNotBlank((String)this.config.getScm().getRepositoriesPath())) {
            Collection<ScmConfiguration> scmConfigurations = new ScmRepositoriesParser().parseRepositoriesFile(this.config.getScm().getRepositoriesPath(), this.config.getScm().getType(), this.config.getScm().getPpk(), this.config.getScm().getUser(), this.config.getScm().getPass());
            scmConnectors = scmConfigurations.stream().map(scm -> ScmConnector.create(scm.getType(), scm.getUrl(), scm.getPpk(), scm.getUser(), scm.getPass(), scm.getBranch(), scm.getTag())).collect(Collectors.toList());
        } else {
            scmConnectors = Arrays.asList(ScmConnector.create(this.config.getScm().getType(), this.config.getScm().getUrl(), this.config.getScm().getPpk(), this.config.getScm().getUser(), this.config.getScm().getPass(), this.config.getScm().getBranch(), this.config.getScm().getTag()));
        }
        if (scmConnectors != null && scmConnectors.stream().anyMatch(scm -> scm != null)) {
            scmConnectors.stream().forEach(scmConnector -> {
                if (scmConnector != null) {
                    this.logger.info("Connecting to SCM");
                    String scmPath = scmConnector.cloneRepository().getPath();
                    Pair<String, StatusCode> result = this.npmInstallScmRepository(this.config.getScm().isNpmInstall(), this.config.getScm().getNpmInstallTimeoutMinutes(), (ScmConnector)scmConnector, separatorFiles, scmPath);
                    scmPath = result.getKey();
                    success[0] = result.getValue();
                    scmPaths.add(scmPath);
                    scannerBaseDirs.add(scmPath);
                    if (!appPathsToDependencyDirs.containsKey("defaultKey")) {
                        appPathsToDependencyDirs.put("defaultKey", new HashSet());
                    }
                    ((Set)appPathsToDependencyDirs.get("defaultKey")).add(scmPath);
                    hasScmConnectors[0] = true;
                }
            });
        }
        if (StringUtils.isNotBlank((String)this.config.getAgent().getError())) {
            this.logger.error(this.config.getAgent().getError());
            if (scmConnectors != null) {
                scmConnectors.forEach(scmConnector -> scmConnector.deleteCloneDirectory());
            }
            return new ProjectsDetails(new ArrayList<AgentProjectInfo>(), StatusCode.ERROR, this.config.getAgent().getError());
        }
        Collection<AgentProjectInfo> projects = null;
        Map<AgentProjectInfo, LinkedList<ViaComponents>> projectToAppPathAndLanguage = null;
        if (this.config.isScanProjectManager()) {
            projects = new PackageManagerExtractor().createProjects();
            projectsDetails = new ProjectsDetails(projects, success[0], "");
        } else if (this.config.isScanDockerImages()) {
            projects = new DockerResolver(this.config).resolveDockerImages();
            projectsDetails = new ProjectsDetails(projects, success[0], "");
        } else {
            ViaLanguage viaLanguage = this.getIaLanguage(this.config.getRequest().getIaLanguage());
            projectToAppPathAndLanguage = new FileSystemScanner(this.config.getResolver(), this.config.getAgent(), this.config.getSender().isEnableImpactAnalysis(), viaLanguage).createProjects(scannerBaseDirs, appPathsToDependencyDirs, hasScmConnectors[0]);
            projectsDetails = new ProjectsDetails(projectToAppPathAndLanguage, success[0], "");
        }
        scmPaths.forEach(directory -> {
            if (directory != null) {
                try {
                    FileUtils.forceDelete((File)new File((String)directory));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        return projectsDetails;
    }

    private ViaLanguage getIaLanguage(String iaLanguage) {
        ViaLanguage[] values = ViaLanguage.values();
        if (iaLanguage != null) {
            for (ViaLanguage value : values) {
                if (!value.toString().toLowerCase().equals(iaLanguage.toLowerCase())) continue;
                return value;
            }
        }
        return null;
    }

    private Pair<String, StatusCode> npmInstallScmRepository(boolean scmNpmInstall, int npmInstallTimeoutMinutes, ScmConnector scmConnector, String separatorFiles, String pathToCloneRepoFiles) {
        StatusCode success = StatusCode.SUCCESS;
        File packageJson = new File(pathToCloneRepoFiles + separatorFiles + PACKAGE_JSON);
        boolean npmInstallFailed = false;
        if (scmNpmInstall && packageJson.exists()) {
            File packageLock = new File(pathToCloneRepoFiles + separatorFiles + PACKAGE_LOCK);
            if (packageLock.exists()) {
                packageLock.delete();
            }
            CommandLineProcess npmInstall = new CommandLineProcess(pathToCloneRepoFiles, new String[]{NPM_COMMAND, "install"});
            this.logger.info("Found package.json file, executing 'npm install' on {}", (Object)scmConnector.getUrl());
            try {
                npmInstall.executeProcessWithoutOutput();
                npmInstall.setTimeoutProcessMinutes(npmInstallTimeoutMinutes);
                if (npmInstall.isErrorInProcess()) {
                    npmInstallFailed = true;
                    this.logger.error("Failed to run 'npm install' on {}", (Object)scmConnector.getUrl());
                }
            }
            catch (IOException e) {
                npmInstallFailed = true;
                this.logger.error("Failed to start 'npm install' {}", (Throwable)e);
            }
            if (npmInstallFailed) {
                success = StatusCode.PRE_STEP_FAILURE;
                scmConnector.deleteCloneDirectory();
                pathToCloneRepoFiles = scmConnector.cloneRepository().getPath();
            }
        }
        return new Pair<String, StatusCode>(pathToCloneRepoFiles, success);
    }
}

