/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import java.util.Arrays;
import java.util.List;

public class ImpactAnalysisExtensionUtils {
    public static final String REGEX_PATTERN_PREFIX = ".*\\.";
    public static final String REGEX_OR = "|";
    public static final String GLOB_PATTERN_PREFIX = "**/*.";
    public static final List<String> JAVA_EXTENSIONS = Arrays.asList("jar");
    public static final List<String> JAVA_SCRIPT_EXTENSIONS = Arrays.asList("package.json");
    public static final String JAVA_EXTENSIONS_PATTERN = ImpactAnalysisExtensionUtils.initializeRegexPattern(JAVA_EXTENSIONS);
    public static final String JAVA_SCRIPT_EXTENSIONS_PATTERN = ImpactAnalysisExtensionUtils.initializeRegexPattern(JAVA_SCRIPT_EXTENSIONS);

    private static String initializeRegexPattern(List<String> extensions) {
        StringBuilder sb = new StringBuilder();
        for (String extension : extensions) {
            sb.append(REGEX_PATTERN_PREFIX);
            sb.append(extension);
            sb.append(REGEX_OR);
        }
        return sb.toString().substring(0, sb.toString().lastIndexOf(REGEX_OR));
    }

    private static String[] initializeGlobPattern(List<String> extensions) {
        String[] globPatterns = new String[extensions.size()];
        for (int i = 0; i < extensions.size(); ++i) {
            globPatterns[i] = GLOB_PATTERN_PREFIX + extensions.get(i);
        }
        return globPatterns;
    }
}

