/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;

public class OfflineReader {
    private final Logger logger = LoggerFactory.getLogger(OfflineReader.class);
    private static final String UTF_8 = "UTF-8";

    public Collection<UpdateInventoryRequest> getAgentProjectsFromRequests(List<String> offlineRequestFiles) {
        LinkedList<UpdateInventoryRequest> projects = new LinkedList<UpdateInventoryRequest>();
        LinkedList<File> requestFiles = new LinkedList<File>();
        if (offlineRequestFiles != null) {
            for (String requestFilePath : offlineRequestFiles) {
                if (!StringUtils.isNotBlank((String)requestFilePath)) continue;
                requestFiles.add(new File(requestFilePath));
            }
        }
        if (!requestFiles.isEmpty()) {
            for (File requestFile : requestFiles) {
                UpdateInventoryRequest updateRequest;
                if (!requestFile.isFile()) {
                    this.logger.warn("'{}' is a folder. Enter a valid file path, folder is not acceptable.", (Object)requestFile.getName());
                    continue;
                }
                Gson gson = new Gson();
                this.logger.debug("Converting offline request to JSON");
                try {
                    FileReader fileReader = new FileReader(requestFile);
                    Throwable throwable = null;
                    try {
                        JsonReader jsonReader = new JsonReader((Reader)fileReader);
                        Throwable throwable2 = null;
                        try {
                            updateRequest = (UpdateInventoryRequest)gson.fromJson(jsonReader, new TypeToken<UpdateInventoryRequest>(){}.getType());
                            this.logger.info("Reading information from request file {}", (Object)requestFile);
                            projects.add(updateRequest);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (jsonReader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    jsonReader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            jsonReader.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (fileReader == null) continue;
                        if (throwable != null) {
                            try {
                                fileReader.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        fileReader.close();
                    }
                }
                catch (JsonSyntaxException e) {
                    try {
                        this.logger.debug("Decompressing zipped offline request");
                        String fileContent = OfflineReader.decompress(requestFile);
                        this.logger.debug("Converting offline request to JSON");
                        updateRequest = (UpdateInventoryRequest)gson.fromJson(fileContent, new TypeToken<UpdateInventoryRequest>(){}.getType());
                        this.logger.info("Reading information from request file {}", (Object)requestFile);
                        projects.add(updateRequest);
                    }
                    catch (IOException ioe) {
                        this.logger.warn("Error parsing request: " + ioe.getMessage());
                    }
                    catch (JsonSyntaxException jse) {
                        this.logger.warn("Error parsing request: " + jse.getMessage());
                    }
                }
                catch (FileNotFoundException e) {
                    this.logger.warn("Error parsing request: " + e.getMessage());
                }
                catch (IOException e) {
                    this.logger.warn("Error parsing request: " + e.getMessage());
                }
            }
        }
        return projects;
    }

    private static String decompress(File file) throws IOException {
        String line;
        if (file == null || !file.exists()) {
            return "";
        }
        byte[] bytes = Base64.getDecoder().decode(IOUtils.toByteArray((InputStream)new FileInputStream(file)));
        GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(bytes));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gzipInputStream, UTF_8));
        StringBuilder outStr = new StringBuilder("");
        while ((line = bf.readLine()) != null) {
            outStr.append(line);
        }
        return outStr.toString();
    }
}

