/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.whitesource.agent.ViaComponents;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.fs.StatusCode;

public class ProjectsDetails {
    private Map<AgentProjectInfo, LinkedList<ViaComponents>> projectToViaComponents;
    private String details;
    private StatusCode statusCode;

    public ProjectsDetails(Map<AgentProjectInfo, LinkedList<ViaComponents>> projectToViaComponents, StatusCode statusCode, String details) {
        this.statusCode = statusCode;
        this.projectToViaComponents = projectToViaComponents;
        this.details = details;
    }

    public ProjectsDetails(Collection<AgentProjectInfo> projects, StatusCode statusCode, String details) {
        HashMap<AgentProjectInfo, LinkedList<ViaComponents>> projectToAppPathAndLanguage = new HashMap<AgentProjectInfo, LinkedList<ViaComponents>>();
        for (AgentProjectInfo project : projects) {
            projectToAppPathAndLanguage.put(project, new LinkedList());
        }
        this.statusCode = statusCode;
        this.projectToViaComponents = projectToAppPathAndLanguage;
        this.details = details;
    }

    public ProjectsDetails() {
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getDetails() {
        return this.details;
    }

    public Map<AgentProjectInfo, LinkedList<ViaComponents>> getProjectToViaComponents() {
        return this.projectToViaComponents;
    }

    public void setProjectToViaComponents(Map<AgentProjectInfo, LinkedList<ViaComponents>> projectToViaComponents) {
        this.projectToViaComponents = projectToViaComponents;
    }

    public void addOfflineProjects(Collection<AgentProjectInfo> projects) {
        if (projects.size() > 0) {
            for (AgentProjectInfo agentProjectInfo : projects) {
                this.getProjectToViaComponents().put(agentProjectInfo, null);
            }
        }
    }

    public Collection<AgentProjectInfo> getProjects() {
        return this.getProjectToViaComponents().keySet();
    }
}

