/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ConfigurationValidation {
    private static final int MAX_EXTRACTION_DEPTH = 7;

    public List<String> getConfigurationErrors(boolean projectPerFolder, String configProjectToken, String configProjectName, String configApiToken, String configFilePath, int archiveDepth, String[] includes, String[] projectPerFolderIncludes, String[] pythonIncludes) {
        String error;
        ArrayList<String> errors = new ArrayList<String>();
        String[] requirements = pythonIncludes[0].split(" ");
        if (StringUtils.isBlank((String)configApiToken)) {
            String error2 = "Could not retrieve apiKey property from " + configFilePath;
            errors.add(error2);
        }
        boolean noProjectToken = StringUtils.isBlank((String)configProjectToken);
        boolean noProjectName = StringUtils.isBlank((String)configProjectName);
        if (noProjectToken && noProjectName && !projectPerFolder) {
            error = "Could not retrieve properties projectName and projectToken from " + configFilePath;
            errors.add(error);
        } else if (!noProjectToken && !noProjectName) {
            error = "Please choose just one of either projectName or projectToken (and not both)";
            errors.add(error);
        }
        if (archiveDepth < 0 || archiveDepth > 7) {
            errors.add("Error: archiveExtractionDepth value should be greater than 0 and less than 7");
        }
        if (includes.length < 1 || StringUtils.isBlank((String)includes[0])) {
            errors.add("Error: includes parameter must have at list one scanning pattern");
        }
        if (projectPerFolder && projectPerFolderIncludes == null) {
            errors.add("projectPerFolderIncludes parameter is empty, specify folders to include or mark as comment to scan all folders");
        }
        if (requirements.length > 0) {
            for (String requirement : requirements) {
                if (requirement.endsWith(".txt")) continue;
                String error3 = "Invalid file name: " + requirement + " " + "in property" + "python.requirementsFileIncludes" + "from " + configFilePath;
                errors.add(error3);
            }
        }
        return errors;
    }
}

