/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestConfiguration {
    private final String projectVersion;
    private final String projectToken;
    private final boolean projectPerSubFolder;
    private final String apiToken;
    private final String userKey;
    private final String requesterEmail;
    private final String productToken;
    private String productName;
    private String productVersion;
    private final String projectName;
    private final List<String> appPaths;
    private final String viaDebug;
    private final int viaAnalysisLevel;
    private final String iaLanguage;

    public RequestConfiguration(@JsonProperty(value="apiKey") String apiToken, @JsonProperty(value="userKey") String userKey, @JsonProperty(value="requesterEmail") String requesterEmail, @JsonProperty(value="projectPerFolder") boolean projectPerSubFolder, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="projectToken") String projectToken, @JsonProperty(value="projectVersion") String projectVersion, @JsonProperty(value="productName") String productName, @JsonProperty(value="productToken") String productToken, @JsonProperty(value="productVersion") String productVersion, @JsonProperty(value="appPath") List<String> appPaths, @JsonProperty(value="viaDebug") String viaDebug, @JsonProperty(value="viaAnalysysLevel") int viaAnalysisLevel, @JsonProperty(value="iaLanguage") String iaLanguage) {
        this.apiToken = apiToken;
        this.userKey = userKey;
        this.requesterEmail = requesterEmail;
        this.projectPerSubFolder = projectPerSubFolder;
        this.projectName = projectName;
        this.projectToken = projectToken;
        this.projectVersion = projectVersion;
        this.productName = productName;
        this.productToken = productToken;
        this.productVersion = productVersion;
        this.viaAnalysisLevel = viaAnalysisLevel;
        this.appPaths = appPaths;
        this.viaDebug = viaDebug;
        this.iaLanguage = iaLanguage;
    }

    @JsonProperty(value="projectName")
    public String getProjectName() {
        return this.projectName;
    }

    @JsonProperty(value="projectVersion")
    public String getProjectVersion() {
        return this.projectVersion;
    }

    @JsonProperty(value="projectToken")
    public String getProjectToken() {
        return this.projectToken;
    }

    @JsonProperty(value="productToken")
    public String getProductToken() {
        return this.productToken;
    }

    @JsonProperty(value="productName")
    public String getProductName() {
        return this.productName;
    }

    @JsonProperty(value="productVersion")
    public String getProductVersion() {
        return this.productVersion;
    }

    @JsonProperty(value="projectPerFolder")
    public boolean isProjectPerSubFolder() {
        return this.projectPerSubFolder;
    }

    @JsonProperty(value="requesterEmail")
    public String getRequesterEmail() {
        return this.requesterEmail;
    }

    @JsonProperty(value="apiKey")
    public String getApiToken() {
        return this.apiToken;
    }

    @JsonProperty(value="appPath")
    public List<String> getAppPaths() {
        return this.appPaths;
    }

    @JsonProperty(value="viaDebug")
    public String getViaDebug() {
        return this.viaDebug;
    }

    @JsonProperty(value="viaAnalysysLevel")
    public int getViaAnalysisLevel() {
        return this.viaAnalysisLevel;
    }

    @JsonProperty(value="userKey")
    public String getUserKey() {
        return this.userKey;
    }

    @JsonProperty(value="iaLanguage")
    public String getIaLanguage() {
        return this.iaLanguage;
    }

    public String getProductNameOrToken() {
        if (StringUtils.isBlank((String)this.getProductToken())) {
            return this.getProductName();
        }
        return this.getProductToken();
    }

    public String toString() {
        return ", projectVersion='" + this.projectVersion + '\n' + ", projectToken='" + this.projectToken + '\n' + ", projectPerSubFolder=" + this.projectPerSubFolder + '\n' + ", apiToken='*******" + '\n' + ", userKey='*******" + '\n' + ", requesterEmail='" + this.requesterEmail + "'" + '\n' + ", productToken='" + this.productToken + '\n' + ", productName='" + this.productName + '\n' + ", productVersion='" + this.productVersion + '\n' + ", projectName='" + this.projectName;
    }
}

