/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.scm;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.scm.ScmConnector;
import org.whitesource.scm.ScmType;
import org.whitesource.scm.passphraseCredentialsProvider;

public class GitConnector
extends ScmConnector {
    private Logger logger = LoggerFactory.getLogger(GitConnector.class);

    public GitConnector(String privateKey, String username, String password, String url, String branch, String tag) {
        super(username, password, url, branch, tag, privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File cloneRepository(File dest) {
        try (Git git = null;){
            String tag;
            String branchName = "master";
            String branch = this.getBranch();
            if (StringUtils.isNotBlank((String)branch)) {
                branchName = branch;
            }
            if (StringUtils.isNotBlank((String)(tag = this.getTag()))) {
                branchName = tag;
            }
            CloneCommand cloneCommand = Git.cloneRepository();
            final String privateKey = this.getPrivateKey();
            if (StringUtils.isNotBlank((String)privateKey)) {
                JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                    protected void configure(OpenSshConfig.Host host, Session session) {
                        String password = GitConnector.this.getPassword();
                        if (StringUtils.isNotBlank((String)password)) {
                            session.setPassword(password);
                        }
                    }

                    protected JSch createDefaultJSch(FS fs) throws JSchException {
                        JSch defaultJSch = super.createDefaultJSch(fs);
                        defaultJSch.addIdentity(privateKey);
                        return defaultJSch;
                    }
                };
                cloneCommand.setTransportConfigCallback(new TransportConfigCallback((SshSessionFactory)sshSessionFactory){
                    final /* synthetic */ SshSessionFactory val$sshSessionFactory;
                    {
                        this.val$sshSessionFactory = sshSessionFactory;
                    }

                    public void configure(Transport transport) {
                        SshTransport sshTransport = (SshTransport)transport;
                        sshTransport.setSshSessionFactory(this.val$sshSessionFactory);
                    }
                });
                cloneCommand.setCredentialsProvider((CredentialsProvider)new passphraseCredentialsProvider(this.getPassword()));
            } else {
                cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.getUsername(), this.getPassword()));
            }
            git = cloneCommand.setURI(this.getUrl()).setBranch(branchName).setDirectory(dest).call();
        }
        return dest;
    }

    @Override
    public ScmType getType() {
        return ScmType.GIT;
    }
}

