/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.scm;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.whitesource.scm.ScmConnector;
import org.whitesource.scm.ScmType;

public class SvnConnector
extends ScmConnector {
    private final Logger logger = LoggerFactory.getLogger(SvnConnector.class);
    private static final String URL_BRANCHES = "/branches/";
    private static final String URL_TAGS = "/tags/";
    private static final String URL_TRUNK = "/trunk";
    private static final String TRUNK = "trunk";

    public SvnConnector(String username, String password, String url, String branch, String tag) {
        super(username, password, url, branch, tag, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File cloneRepository(File dest) {
        String url = this.getUrl();
        String branch = this.getBranch();
        String tag = this.getTag();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(url);
        if (StringUtils.isNotBlank((String)branch)) {
            if (branch.equalsIgnoreCase(TRUNK)) {
                if (!url.endsWith(TRUNK)) {
                    urlBuilder.append(URL_TRUNK);
                }
            } else {
                urlBuilder.append(URL_BRANCHES);
                urlBuilder.append(branch);
            }
        } else if (StringUtils.isNotBlank((String)tag)) {
            urlBuilder.append(URL_TAGS);
            urlBuilder.append(tag);
        }
        SVNClientManager clientManager = SVNClientManager.newInstance((DefaultSVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (String)this.getUsername(), (String)this.getPassword());
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        SvnOperationFactory svnOperationFactory = new SvnOperationFactory();
        try {
            SvnCheckout checkout = svnOperationFactory.createCheckout();
            checkout.setSingleTarget(SvnTarget.fromFile((File)dest));
            checkout.setSource(SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)urlBuilder.toString())));
            checkout.setRevision(SVNRevision.HEAD);
            checkout.run();
        }
        catch (SVNException e) {
            this.logger.error("error during checkout: {}", (Object)e.getMessage());
        }
        finally {
            svnOperationFactory.dispose();
        }
        return dest;
    }

    @Override
    public ScmType getType() {
        return ScmType.SVN;
    }
}

