/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.utils.CommandLineProcess;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.fs.Main;
import org.whitesource.fs.ProjectsDetails;
import org.whitesource.fs.StatusCode;
import org.whitesource.fs.configuration.ConfigurationSerializer;
import org.whitesource.web.ResultDto;

public class FsaVerticle
extends AbstractVerticle {
    private final Logger logger = LoggerFactory.getLogger(FsaVerticle.class);
    public static final String API_ANALYZE = "/analyze";
    public static final String API_SEND = "/send";
    public static final String HOME = "/";
    public static final String WELCOME_MESSAGE = "<h1>File system agent is up and running </h1>";
    public static final String CONFIGURATION = "configuration";
    public static final String KEYSTORE_JKS = "keystore.jks";
    private FSAConfiguration localFsaConfiguration;

    public void start(Future<Void> fut) {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)BodyHandler.create());
        router.post(API_ANALYZE).blockingHandler(this::analyze);
        router.post(API_SEND).blockingHandler(this::send);
        router.get(HOME).handler(this::welcome);
        String config = this.config().getString(CONFIGURATION);
        this.localFsaConfiguration = config == null ? new FSAConfiguration() : ConfigurationSerializer.getFromString(config, FSAConfiguration.class, false);
        String certificate = this.localFsaConfiguration.getEndpoint().getCertificate();
        String pass = this.localFsaConfiguration.getEndpoint().getPass();
        if (StringUtils.isEmpty((String)certificate) || StringUtils.isEmpty((String)pass) && this.localFsaConfiguration.getEndpoint().isSsl()) {
            certificate = KEYSTORE_JKS;
            pass = UUID.randomUUID().toString();
            this.generateCertificateAndPass(certificate, pass);
        }
        this.vertx.createHttpServer(new HttpServerOptions().setSsl(this.localFsaConfiguration.getEndpoint().isSsl()).setKeyStoreOptions(new JksOptions().setPath(certificate).setPassword(pass))).requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen(this.config().getInteger("endpoint.port", Integer.valueOf(this.localFsaConfiguration.getEndpoint().getPort())).intValue(), result -> {
            if (result.succeeded()) {
                this.logger.info("Http server completed..");
                fut.complete();
            } else {
                fut.fail(result.cause());
                this.logger.warn("Http server failed..");
            }
        });
    }

    private boolean generateCertificateAndPass(String keystoreName, String password) {
        String keyToolPath = Paths.get(System.getProperty("java.home"), "bin", "keytool").toString();
        CharSequence[] params = new String[]{keyToolPath, "-genkey", "-alias", "replserver", "-keyalg", "RSA", "-keystore", keystoreName, "-dname", "\"CN=author, OU=Whitesource, O=WS, L=Location, S=State, C=US\"", "-storepass", password, "-keypass", password};
        if (SystemUtils.IS_OS_LINUX) {
            params = new String[]{keyToolPath, "-genkey", "-alias", "replserver", "-keyalg", "RSA", "-keystore", keystoreName, "-dname", "CN=author, OU=Whitesource, O=WS, L=Location, S=State, C=US", "-storepass", password, "-keypass", password};
        }
        CommandLineProcess commandLineProcess = new CommandLineProcess(System.getProperty("user.dir"), (String[])params);
        try {
            if (Files.exists(Paths.get(keystoreName, new String[0]), new LinkOption[0])) {
                Files.delete(Paths.get(keystoreName, new String[0]));
            }
            this.logger.debug("Running: " + String.join((CharSequence)" ", params));
            commandLineProcess.executeProcess();
            if (commandLineProcess.isErrorInProcess()) {
                this.logger.error("Error creating self signed certificate");
                return false;
            }
            this.logger.info("Self signed certificate created");
            return true;
        }
        catch (IOException e) {
            this.logger.debug("Error creating certificate" + e);
            this.logger.error("Error creating self signed certificate");
            return false;
        }
    }

    private void send(RoutingContext context) {
        this.vertx.executeBlocking(future -> {
            ProjectsDetails resultProjects = this.getProjects(context, true);
            future.complete((Object)resultProjects);
        }, false, res -> {
            if (res.failed()) {
                this.logger.error("error running blocking request:", (Object)res.cause().getMessage());
            } else {
                ProjectsDetails resultProjects = (ProjectsDetails)res.result();
                ResultDto<String, StatusCode> resultDto = new ResultDto<String, StatusCode>(resultProjects.getDetails(), resultProjects.getStatusCode());
                this.handleResponse(context, resultDto);
            }
        });
    }

    public void analyze(RoutingContext context) {
        ProjectsDetails result = this.getProjects(context, false);
        ResultDto<ProjectsDetails, StatusCode> resultDto = new ResultDto<ProjectsDetails, StatusCode>(new ProjectsDetails(result.getProjects(), result.getStatusCode(), result.getDetails()), result.getStatusCode());
        this.handleResponse(context, resultDto);
    }

    private void handleResponse(RoutingContext context, ResultDto resultDto) {
        String result = null;
        try {
            result = new ObjectMapper().writeValueAsString((Object)resultDto);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error writing json:", (Throwable)e);
            context.response().end("Scanning has failed");
        }
        context.response().end(result);
    }

    private void welcome(RoutingContext context) {
        context.response().end(WELCOME_MESSAGE);
    }

    private ProjectsDetails getProjects(RoutingContext context, boolean shouldSend) {
        FSAConfiguration webFsaConfiguration = ConfigurationSerializer.getFromString(context.getBodyAsString(), FSAConfiguration.class, false);
        if (webFsaConfiguration != null) {
            HashMap result = ConfigurationSerializer.getFromString(context.getBodyAsString(), HashMap.class, false);
            FSAConfiguration mergedFsaConfiguration = this.mergeConfigurations(this.localFsaConfiguration, result);
            Main main = new Main();
            return main.scanAndSend(mergedFsaConfiguration, shouldSend);
        }
        return new ProjectsDetails(new ArrayList<AgentProjectInfo>(), StatusCode.ERROR, "Error parsing the request");
    }

    private FSAConfiguration mergeConfigurations(FSAConfiguration baseFsaConfiguration, HashMap<String, Object> parameterMap) {
        Properties properties = ConfigurationSerializer.getAsProperties(parameterMap);
        FSAConfiguration.ignoredWebProperties.forEach(property -> {
            if (properties.containsKey(property)) {
                this.logger.info("Property " + property + " will be ignored");
                properties.remove(property);
            }
        });
        Properties propertiesLocal = ConfigurationSerializer.getAsProperties(baseFsaConfiguration);
        Properties merged = new Properties();
        merged.putAll((Map<?, ?>)propertiesLocal);
        merged.putAll((Map<?, ?>)properties);
        return new FSAConfiguration(merged);
    }
}

