/**
 * Copyright (C) 2016 White Source Ltd.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.whitesource.agent.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;

/**
 * Info object describing a Vulnerability info
 *
 * Created by anna.rozin
 *
 * @since 2.2.8
 */
public class VulnerabilityInfo implements Serializable {

    /* --- Static members --- */

    private static final long serialVersionUID = 86315184735909079L;

    /* --- Members --- */

    private String name;
    private String severity;
    private float score;
    private Collection<String> elements;
    private Collection<VulnerableEntity> vulnerableEntities;


    /* --- Constructors --- */

    public VulnerabilityInfo () {
        this.elements = new LinkedList<>();
        this.vulnerableEntities = new LinkedList<>();
    }

    /* --- Getters / Setters --- */

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSeverity() {
        return severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public float getScore() {
        return score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public Collection<String> getElements() {
        return elements;
    }

    public void setElements(Collection<String> elements) {
        this.elements = elements;
    }

    public Collection<VulnerableEntity> getVulnerableEntities() {
        return vulnerableEntities;
    }

    public void setVulnerableEntities(Collection<VulnerableEntity> vulnerableEntities) {
        this.vulnerableEntities = vulnerableEntities;
    }
}