package org.whitesource.agent.api.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class VulnerabilityMetadata implements Serializable {
    private String fixVersion;
    private String cveId;
    private String title;
    private String description;
    private String severity;
    private Map<String, String> vendorSeverity;
    private List<String> cweIDs;
    private Map<String, CvssInfo> cvss;
    private List<String> references;
    private Date publishDate;
    private Date lastModifiedDate;

    /* --- Constructors --- */

    /**
     * Default constructor
     */
    public VulnerabilityMetadata() {}


    public String getFixVersion() {
        return fixVersion;
    }

    public void setFixVersion(String fixVersion) {
        this.fixVersion = fixVersion;
    }

    public String getCveId() {
        return cveId;
    }

    public void setCveId(String cveId) {
        this.cveId = cveId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSeverity() {
        return severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public Map<String, String> getVendorSeverity() {
        return vendorSeverity;
    }

    public void setVendorSeverity(Map<String, String> vendorSeverity) {
        this.vendorSeverity = vendorSeverity;
    }

    public List<String> getCweIDs() {
        return cweIDs;
    }

    public void setCweIDs(List<String> cweIDs) {
        this.cweIDs = cweIDs;
    }

    public Map<String, CvssInfo> getCvss() {
        return cvss;
    }

    public void setCvss(Map<String, CvssInfo> cvss) {
        this.cvss = cvss;
    }

    public List<String> getReferences() {
        return references;
    }

    public void setReferences(List<String> references) {
        this.references = references;
    }

    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}
