/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.api.dispatch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.whitesource.agent.api.dispatch.RequestType;
import org.whitesource.agent.api.dispatch.ServiceRequest;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.ScanSummaryInfo;
import org.whitesource.agent.api.model.contribution.ContributionInfo;

public abstract class BaseRequest<R>
implements ServiceRequest<R> {
    private static final long serialVersionUID = 4691829529579651426L;
    protected final RequestType type;
    protected String agent;
    protected String agentVersion;
    protected String pluginVersion;
    protected String orgToken;
    protected String userKey;
    protected String product;
    protected String productVersion;
    protected long timeStamp;
    protected String requesterEmail;
    protected Collection<AgentProjectInfo> projects;
    protected boolean aggregateModules;
    protected boolean preserveModuleStructure;
    protected String aggregateProjectName;
    protected String aggregateProjectToken;
    protected String logData;
    protected String scanComment;
    protected String productToken;
    protected Map<String, String> extraProperties;
    protected ScanSummaryInfo scanSummaryInfo;
    protected Collection<ContributionInfo> contributions;

    public BaseRequest(RequestType type) {
        this(type, null, null, null);
    }

    public BaseRequest(RequestType type, String agent) {
        this(type, agent, null, null);
    }

    public BaseRequest(RequestType type, String agent, String agentVersion, String pluginVersion) {
        this.type = type;
        this.agent = agent;
        this.agentVersion = agentVersion;
        this.pluginVersion = pluginVersion;
        this.timeStamp = System.currentTimeMillis();
        this.projects = new ArrayList<AgentProjectInfo>();
        this.extraProperties = new HashMap<String, String>();
        this.contributions = new LinkedList<ContributionInfo>();
    }

    @Override
    public RequestType type() {
        return this.type;
    }

    @Override
    public String orgToken() {
        return this.orgToken;
    }

    @Override
    public String agent() {
        return this.agent;
    }

    @Override
    public String agentVersion() {
        return this.agentVersion;
    }

    @Override
    public String pluginVersion() {
        return this.pluginVersion;
    }

    @Override
    public String product() {
        return this.product;
    }

    @Override
    public String productVersion() {
        return this.productVersion;
    }

    @Override
    public long timeStamp() {
        return this.timeStamp;
    }

    @Override
    public String requesterEmail() {
        return this.requesterEmail;
    }

    @Override
    public String userKey() {
        return this.userKey;
    }

    @Override
    public boolean aggregateModules() {
        return this.aggregateModules;
    }

    @Override
    public boolean preserveModuleStructure() {
        return this.preserveModuleStructure;
    }

    @Override
    public String aggregateProjectName() {
        return this.aggregateProjectName;
    }

    @Override
    public String aggregateProjectToken() {
        return this.aggregateProjectToken;
    }

    @Override
    public String logData() {
        return this.logData;
    }

    @Override
    public String scanComment() {
        return this.scanComment;
    }

    @Override
    public String productToken() {
        return this.productToken;
    }

    @Override
    public Map<String, String> extraProperties() {
        return this.extraProperties;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public void setOrgToken(String orgToken) {
        this.orgToken = orgToken;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setRequesterEmail(String requesterEmail) {
        this.requesterEmail = requesterEmail;
    }

    public Collection<AgentProjectInfo> getProjects() {
        return this.projects;
    }

    public void setProjects(Collection<AgentProjectInfo> projects) {
        this.projects = projects;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public void setAggregateModules(boolean aggregateModules) {
        this.aggregateModules = aggregateModules;
    }

    public void setPreserveModuleStructure(boolean preserveModuleStructure) {
        this.preserveModuleStructure = preserveModuleStructure;
    }

    public void setAggregateProjectName(String aggregateProjectName) {
        this.aggregateProjectName = aggregateProjectName;
    }

    public void setAggregateProjectToken(String aggregateProjectToken) {
        this.aggregateProjectToken = aggregateProjectToken;
    }

    public void setLogData(String logData) {
        this.logData = logData;
    }

    public void setScanComment(String scanComment) {
        this.scanComment = scanComment;
    }

    public void setProductToken(String productToken) {
        this.productToken = productToken;
    }

    public Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Map<String, String> extraProperties) {
        this.extraProperties = extraProperties;
    }

    public ScanSummaryInfo getScanSummaryInfo() {
        return this.scanSummaryInfo;
    }

    public void setScanSummaryInfo(ScanSummaryInfo scanSummaryInfo) {
        this.scanSummaryInfo = scanSummaryInfo;
    }

    public Collection<ContributionInfo> getContributions() {
        return this.contributions;
    }

    public void setContributions(Collection<ContributionInfo> contributions) {
        this.contributions = contributions;
    }
}

