/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.whitesource.agent.api.model.ScanMethod;
import org.whitesource.agent.api.model.StepInfo;

public class ScanSummaryInfo
implements Serializable {
    private static final long serialVersionUID = -3801913583253812987L;
    private long totalElapsedTime;
    private Collection<StepInfo> stepsSummaryInfo = new LinkedList<StepInfo>();
    private List<String> packageManagers = new LinkedList<String>();
    private List<String> sourceControlManagers;
    private List<String> containerRegistries = new LinkedList<String>();
    private List<String> otherIntegrationTypes;
    private boolean isPrivileged;
    private ScanMethod scanMethod;
    private Map<String, String> scanStatistics;

    public ScanSummaryInfo() {
        this.sourceControlManagers = new LinkedList<String>();
        this.otherIntegrationTypes = new LinkedList<String>();
        this.scanStatistics = new HashMap<String, String>();
    }

    public ScanSummaryInfo(long totalElapsedTime, Collection<StepInfo> stepsSummaryInfo) {
        this();
        this.totalElapsedTime = totalElapsedTime;
        this.stepsSummaryInfo = stepsSummaryInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScanSummaryInfo)) {
            return false;
        }
        ScanSummaryInfo that = (ScanSummaryInfo)o;
        return this.totalElapsedTime == that.totalElapsedTime && Objects.equals(this.stepsSummaryInfo, that.stepsSummaryInfo);
    }

    public int hashCode() {
        return Objects.hash(this.totalElapsedTime, this.stepsSummaryInfo);
    }

    public Map<String, String> getScanStatistics() {
        return this.scanStatistics;
    }

    public void setScanStatistics(Map<String, String> scanStatistics) {
        this.scanStatistics = scanStatistics;
    }

    public long getTotalElapsedTime() {
        return this.totalElapsedTime;
    }

    public void setTotalElapsedTime(long totalElapsedTime) {
        this.totalElapsedTime = totalElapsedTime;
    }

    public Collection<StepInfo> getStepsSummaryInfo() {
        return this.stepsSummaryInfo;
    }

    public void setStepsSummaryInfo(Collection<StepInfo> stepsSummaryInfo) {
        this.stepsSummaryInfo = stepsSummaryInfo;
    }

    public List<String> getPackageManagers() {
        return this.packageManagers;
    }

    public void setPackageManagers(List<String> packageManagers) {
        this.packageManagers = packageManagers;
    }

    public List<String> getSourceControlManagers() {
        return this.sourceControlManagers;
    }

    public void setSourceControlManagers(List<String> sourceControlManagers) {
        this.sourceControlManagers = sourceControlManagers;
    }

    public List<String> getContainerRegistries() {
        return this.containerRegistries;
    }

    public void setContainerRegistries(List<String> containerRegistries) {
        this.containerRegistries = containerRegistries;
    }

    public List<String> getOtherIntegrationTypes() {
        return this.otherIntegrationTypes;
    }

    public void setOtherIntegrationTypes(List<String> otherIntegrationTypes) {
        this.otherIntegrationTypes = otherIntegrationTypes;
    }

    public boolean isPrivileged() {
        return this.isPrivileged;
    }

    public void setPrivileged(boolean privileged) {
        this.isPrivileged = privileged;
    }

    public ScanMethod getScanMethod() {
        return this.scanMethod;
    }

    public void setScanMethod(ScanMethod scanMethod) {
        this.scanMethod = scanMethod;
    }
}

