/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.hash;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static final String PLATFORM_DEPENDENT_TMP_DIRECTORY = System.getProperty("java.io.tmpdir") + File.separator + "WhiteSource-PlatformDependentFiles";
    public static final int MAX_FILE_SIZE = 0xA00000;
    private static final String CRLF = "\r\n";
    private static final String NEW_LINE = "\n";
    private static final String EMPTY_STRING = "";

    private FileUtils() {
    }

    public static File createOtherPlatformFile(File originalPlatform) {
        long length = originalPlatform.length();
        if (length < 0xA00000L && length < Runtime.getRuntime().freeMemory()) {
            try {
                byte[] byteArray = org.apache.commons.io.FileUtils.readFileToByteArray((File)originalPlatform);
                String fileText = new String(byteArray);
                File otherPlatformFile = new File(PLATFORM_DEPENDENT_TMP_DIRECTORY, originalPlatform.getName());
                if (fileText.contains(CRLF)) {
                    org.apache.commons.io.FileUtils.write((File)otherPlatformFile, (CharSequence)fileText.replaceAll(CRLF, NEW_LINE));
                } else if (fileText.contains(NEW_LINE)) {
                    org.apache.commons.io.FileUtils.write((File)otherPlatformFile, (CharSequence)fileText.replaceAll(NEW_LINE, CRLF));
                }
                if (otherPlatformFile.exists()) {
                    return otherPlatformFile;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static String cleanLine(String line) {
        return line.replace("/**", EMPTY_STRING).replace("/*", EMPTY_STRING).replace("*", EMPTY_STRING).replace("#", EMPTY_STRING).replace("/", EMPTY_STRING).replace("\\t", EMPTY_STRING).replace("\\n", EMPTY_STRING).trim();
    }

    private static void deleteFile(File file) {
        if (file != null) {
            try {
                org.apache.commons.io.FileUtils.forceDelete((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

