/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public class ZipUtils {
    private static final String JAVA_TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String ZIP_UTILS = System.getProperty("WSZipUtils");
    private static final String UTF_8 = "UTF-8";
    private static final int BYTES_BUFFER_SIZE = 32768;
    private static final int STRING_MAX_SIZE = 32768;
    private static final String TMP_IN_ = "tmp_in_";
    private static final String TMP_OUT_ = "tmp_out_";
    private static final String ZIP_UTILS_SUFFIX = ".json";
    private static final int N_THREADS = 2;

    @Deprecated
    public static String compress(String text) throws IOException {
        String result;
        block25: {
            if (text != null && text.length() > 0) {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream(text.length());
                     GZIPOutputStream gzipos = new GZIPOutputStream(baos);){
                    gzipos.write(text.getBytes(UTF_8));
                    gzipos.close();
                    baos.close();
                    result = Base64.encodeBase64String((byte[])baos.toByteArray());
                    break block25;
                }
            }
            result = text;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static String decompress(String text) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path decompressChunks(String text) throws IOException {
        File tempFileOut = File.createTempFile(TMP_OUT_, ZIP_UTILS_SUFFIX, new File(JAVA_TEMP_DIR));
        if (text == null || text.length() == 0) {
            return null;
        }
        byte[] bytes = Base64.decodeBase64((String)text);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            ZipUtils.decompressChunks(inputStream, tempFileOut.toPath());
            Path path = tempFileOut.toPath();
            return path;
        }
    }

    public static void decompressChunks(InputStream inputStream, Path tempFileOut) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(tempFileOut, new OpenOption[0]);
             GZIPInputStream chunkZipper = new GZIPInputStream(inputStream);
             BufferedInputStream in = new BufferedInputStream(chunkZipper);){
            int len;
            byte[] buffer = new byte[32768];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                byte[] writtenBytes = new byte[len];
                ZipUtils.getBytes(buffer, 0, len, writtenBytes, 0);
                String val = new String(writtenBytes, StandardCharsets.UTF_8);
                writer.write(val);
            }
        }
    }

    public static String compressString(String text) throws IOException {
        try (ByteArrayOutputStream exportByteArrayOutputStream = new ByteArrayOutputStream();){
            ZipUtils.fillExportStreamCompress(text, (OutputStream)exportByteArrayOutputStream);
            String string = ZipUtils.getStringFromEncode(exportByteArrayOutputStream.toByteArray());
            return string;
        }
    }

    public static void compressString(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ZipUtils.fillExportStreamCompress(inputStream, (OutputStream)byteArrayOutputStream);
            String result = ZipUtils.getStringFromEncode(byteArrayOutputStream.toByteArray());
            try (PrintWriter printWriter = new PrintWriter(outputStream);){
                printWriter.write(result);
            }
        }
    }

    public static String decompressString(String text) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        ZipUtils.fillExportStreamDecompress(text, stringBuilder);
        return stringBuilder.toString();
    }

    public static void decompressString(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
             PrintWriter printWriter = new PrintWriter(outputStream);){
            int len;
            byte[] buffer = new byte[32768];
            while ((len = ((InputStream)bufferedInputStream).read(buffer)) > 0) {
                String val = new String(buffer, StandardCharsets.UTF_8);
                String str = ZipUtils.decompressString(val);
                printWriter.write(str);
            }
        }
    }

    public static String compressChunks(String text) throws IOException {
        String result;
        File tempFileOut;
        File tempFileIn;
        block50: {
            Path tempFolder = Paths.get(JAVA_TEMP_DIR, ZIP_UTILS);
            tempFileIn = File.createTempFile(TMP_IN_, ZIP_UTILS_SUFFIX, tempFolder.toFile());
            tempFileOut = File.createTempFile(TMP_OUT_, ZIP_UTILS_SUFFIX, tempFolder.toFile());
            ZipUtils.writeChunkBytes(text, tempFileIn);
            if (text != null && text.length() > 0) {
                try (FileInputStream in = new FileInputStream(tempFileIn);
                     FileOutputStream fileOutputStream = new FileOutputStream(tempFileOut);
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                     GZIPOutputStream out = new GZIPOutputStream(bufferedOutputStream);){
                    int len;
                    byte[] bytes = new byte[32768];
                    while ((len = ((InputStream)in).read(bytes)) > 0) {
                        ((OutputStream)out).write(bytes, 0, len);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                    result = Base64.encodeBase64String((byte[])Files.readAllBytes(tempFileOut.toPath()));
                    break block50;
                }
            }
            result = text;
        }
        Files.deleteIfExists(tempFileIn.toPath());
        Files.deleteIfExists(tempFileOut.toPath());
        return result;
    }

    private static String getStringFromEncode(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    private static void fillExportStreamCompress(final InputStream inputStream, final OutputStream outputStream) {
        try (final PipedInputStream pipedInputStream = new PipedInputStream();
             final PipedOutputStream pipedOutputStream = new PipedOutputStream();){
            pipedInputStream.connect(pipedOutputStream);
            Runnable producer = new Runnable(){

                @Override
                public void run() {
                    ZipUtils.produceCompressDataFromStream(inputStream, pipedOutputStream);
                }
            };
            Runnable consumer = new Runnable(){

                @Override
                public void run() {
                    ZipUtils.consumeCompressData(pipedInputStream, outputStream);
                }
            };
            ZipUtils.transferData(producer, consumer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void fillExportStreamCompress(final String text, final OutputStream exportByteArrayOutputStream) {
        try (final PipedInputStream pipedInputStream = new PipedInputStream();
             final PipedOutputStream pipedOutputStream = new PipedOutputStream();){
            pipedInputStream.connect(pipedOutputStream);
            Runnable producer = new Runnable(){

                @Override
                public void run() {
                    ZipUtils.produceCompressDataFromText(text, pipedOutputStream);
                }
            };
            Runnable consumer = new Runnable(){

                @Override
                public void run() {
                    ZipUtils.consumeCompressData(pipedInputStream, exportByteArrayOutputStream);
                }
            };
            ZipUtils.transferData(producer, consumer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferData(Runnable producer, Runnable consumer) {
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        try {
            threadPool.submit(producer);
            threadPool.submit(consumer).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        finally {
            threadPool.shutdown();
        }
    }

    private static void consumeCompressData(PipedInputStream pipedInputStream, OutputStream exportByteArrayOutputStream) {
        try (GZIPOutputStream out = new GZIPOutputStream(new BufferedOutputStream(exportByteArrayOutputStream));){
            try {
                int len;
                byte[] bytes = new byte[32768];
                while ((len = pipedInputStream.read(bytes)) > 0) {
                    ((OutputStream)out).write(bytes, 0, len);
                }
                ((OutputStream)out).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void produceCompressDataFromStream(InputStream inputStream, PipedOutputStream pipedOutputStream) {
        try (BufferedInputStream in = new BufferedInputStream(inputStream);){
            int len;
            byte[] buffer = new byte[32768];
            while ((len = in.read(buffer)) > 0) {
                pipedOutputStream.write(buffer, 0, len);
            }
            pipedOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void produceCompressDataFromText(String text, PipedOutputStream pipedOutputStream) {
        int start_String = 0;
        int chunk = text.length();
        if (text.length() > 32768) {
            chunk = text.length() / 32768;
        }
        try {
            while (start_String < text.length()) {
                int end = start_String + chunk;
                if (end > text.length()) {
                    end = text.length();
                }
                byte[] bytes = text.substring(start_String, end).getBytes(StandardCharsets.UTF_8);
                pipedOutputStream.write(bytes);
                start_String = end;
            }
            pipedOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void fillExportStreamDecompress(final String text, final StringBuilder stringBuilder) {
        try (final PipedInputStream pipedInputStream = new PipedInputStream();
             final PipedOutputStream pipedOutputStream = new PipedOutputStream();){
            pipedInputStream.connect(pipedOutputStream);
            Runnable producer = new Runnable(){

                @Override
                public void run() {
                    ZipUtils.produceDecompressData(text, pipedOutputStream);
                }
            };
            Runnable consumer = new Runnable(){

                @Override
                public void run() {
                    ZipUtils.consumeDecompressData(pipedInputStream, stringBuilder);
                }
            };
            ZipUtils.transferData(producer, consumer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void consumeDataDecompressStream(PipedInputStream pipedInputStream, OutputStream outputStream) {
        try (GZIPInputStream chunkZipper = new GZIPInputStream(pipedInputStream);
             BufferedInputStream in = new BufferedInputStream(chunkZipper);){
            int len;
            byte[] buffer = new byte[32768];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            pipedInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void consumeDecompressData(PipedInputStream pipedInputStream, StringBuilder stringBuilder) {
        try (GZIPInputStream chunkZipper = new GZIPInputStream(pipedInputStream);
             BufferedInputStream in = new BufferedInputStream(chunkZipper);){
            int len;
            byte[] buffer = new byte[32768];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                if (len < buffer.length) {
                    byte[] writtenBytes = new byte[len];
                    ZipUtils.getBytes(buffer, 0, len, writtenBytes, 0);
                    stringBuilder.append(new String(writtenBytes, StandardCharsets.UTF_8));
                    continue;
                }
                stringBuilder.append(new String(buffer, StandardCharsets.UTF_8));
            }
            pipedInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void getBytes(byte[] source, int srcBegin, int srcEnd, byte[] destination, int dstBegin) {
        System.arraycopy(source, srcBegin, destination, dstBegin, srcEnd - srcBegin);
    }

    private static void produceDecompressData(String text, PipedOutputStream pipedOutputStream) {
        try {
            byte[] bytes = ZipUtils.getStringFromDecode(text);
            pipedOutputStream.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] getStringFromDecode(String text) throws IOException {
        return Base64.decodeBase64((String)text);
    }

    private static void writeChunkBytes(String text, File tempFileIn) throws IOException {
        try (FileOutputStream writer = new FileOutputStream(tempFileIn);){
            int chunk = text.length();
            if (text.length() > 32768) {
                chunk = text.length() / 32768;
            }
            int startString = 0;
            while (startString < text.length()) {
                int endString = startString + chunk;
                if (endString > text.length()) {
                    endString = text.length();
                }
                byte[] bytes = text.substring(startString, endString).getBytes(StandardCharsets.UTF_8);
                writer.write(bytes);
                startString = endString;
            }
        }
    }

    private ZipUtils() {
    }
}

