/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.implementation.FormIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.SenseIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class EntityIdValueImpl
extends ValueImpl
implements EntityIdValue {
    public static final String JSON_ENTITY_TYPE_ITEM = "item";
    public static final String JSON_ENTITY_TYPE_PROPERTY = "property";
    public static final String JSON_ENTITY_TYPE_LEXEME = "lexeme";
    public static final String JSON_ENTITY_TYPE_FORM = "form";
    public static final String JSON_ENTITY_TYPE_SENSE = "sense";
    private final String siteIri;
    private final JacksonInnerEntityId value;

    protected EntityIdValueImpl(String id, String siteIri) {
        super("wikibase-entityid");
        this.value = new JacksonInnerEntityId(id);
        Validate.notNull((Object)siteIri, (String)"Entity site IRIs cannot be null", (Object[])new Object[0]);
        this.siteIri = siteIri;
    }

    @JsonCreator
    protected EntityIdValueImpl(@JsonProperty(value="value") JacksonInnerEntityId value, @JacksonInject String siteIri) {
        super("wikibase-entityid");
        this.value = value;
        this.siteIri = siteIri;
    }

    static EntityIdValue fromId(String id, String siteIri) {
        switch (EntityIdValueImpl.guessEntityTypeFromId(id)) {
            case "item": {
                return new ItemIdValueImpl(id, siteIri);
            }
            case "property": {
                return new PropertyIdValueImpl(id, siteIri);
            }
            case "lexeme": {
                return new LexemeIdValueImpl(id, siteIri);
            }
            case "form": {
                return new FormIdValueImpl(id, siteIri);
            }
            case "sense": {
                return new SenseIdValueImpl(id, siteIri);
            }
        }
        throw new IllegalArgumentException("Entity id \"" + id + "\" is not supported.");
    }

    static String guessEntityTypeFromId(String id) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Entity ids should not be empty.");
        }
        switch (id.charAt(0)) {
            case 'L': {
                if (id.contains("-F")) {
                    return JSON_ENTITY_TYPE_FORM;
                }
                if (id.contains("-S")) {
                    return JSON_ENTITY_TYPE_SENSE;
                }
                return JSON_ENTITY_TYPE_LEXEME;
            }
            case 'P': {
                return JSON_ENTITY_TYPE_PROPERTY;
            }
            case 'Q': {
                return JSON_ENTITY_TYPE_ITEM;
            }
        }
        throw new IllegalArgumentException("Entity id \"" + id + "\" is not supported.");
    }

    @JsonProperty(value="value")
    public JacksonInnerEntityId getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public String getIri() {
        return this.getSiteIri().concat(this.getId());
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.value.getStringId();
    }

    @Override
    @JsonIgnore
    public String getSiteIri() {
        if (this.siteIri != null) {
            return this.siteIri;
        }
        throw new RuntimeException("Cannot access the site IRI id of an insufficiently initialised Jackson value.");
    }

    protected void assertHasJsonEntityType(String expectedType) {
        if (!expectedType.equals(this.value.entityType)) {
            throw new IllegalArgumentException("The value should have the entity-type \"" + expectedType + "\": " + this);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class JacksonInnerEntityId {
        private final String id;
        private final String entityType;
        private final int numericId;

        JacksonInnerEntityId(String id) {
            this.id = id;
            this.entityType = EntityIdValueImpl.guessEntityTypeFromId(id);
            this.numericId = this.buildNumericId(id);
        }

        @JsonCreator
        JacksonInnerEntityId(@JsonProperty(value="id") String id, @JsonProperty(value="numeric-id") int numericId, @JsonProperty(value="entity-type") String entityType) {
            if (id == null) {
                if (entityType == null || numericId == 0) {
                    throw new IllegalArgumentException("You should provide an id or an entity type and a numeric id");
                }
                this.id = this.buildIdFromNumericId(entityType, numericId);
                this.entityType = entityType;
                this.numericId = numericId;
            } else {
                this.id = id;
                if (entityType == null || numericId == 0) {
                    this.entityType = EntityIdValueImpl.guessEntityTypeFromId(id);
                    this.numericId = this.buildNumericId(id);
                } else {
                    if (!id.equals(this.buildIdFromNumericId(entityType, numericId))) {
                        throw new IllegalArgumentException("Numerical id is different from the string id");
                    }
                    this.entityType = entityType;
                    this.numericId = numericId;
                }
            }
        }

        @JsonProperty(value="entity-type")
        public String getJsonEntityType() {
            return this.entityType;
        }

        @JsonProperty(value="numeric-id")
        public int getNumericId() {
            return this.numericId;
        }

        @JsonProperty(value="id")
        public String getStringId() {
            return this.id;
        }

        private int buildNumericId(String id) {
            if (id.length() <= 1) {
                throw new IllegalArgumentException("Wikibase entity ids must have the form \"(L|P|Q)<positive integer>\". Given id was \"" + id + "\"");
            }
            try {
                return Integer.parseInt(id.substring(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Wikibase entity ids must have the form \"(L|P|Q)<positive integer>\". Given id was \"" + id + "\"");
            }
        }

        private String buildIdFromNumericId(String entityType, int numericId) {
            switch (entityType) {
                case "item": {
                    return "Q" + numericId;
                }
                case "lexeme": {
                    return "L" + numericId;
                }
                case "property": {
                    return "P" + numericId;
                }
            }
            throw new IllegalArgumentException("Entities of type \"" + entityType + "\" are not supported in property values.");
        }
    }
}

