/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.implementation.NoValueSnakImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.SomeValueSnakImpl;
import org.wikidata.wdtk.datamodel.implementation.ValueSnakImpl;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.Value;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="snaktype")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NoValueSnakImpl.class, name="novalue"), @JsonSubTypes.Type(value=SomeValueSnakImpl.class, name="somevalue"), @JsonSubTypes.Type(value=ValueSnakImpl.class, name="value")})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class SnakImpl
implements Snak {
    public static final String JSON_SNAK_TYPE_VALUE = "value";
    public static final String JSON_SNAK_TYPE_SOMEVALUE = "somevalue";
    public static final String JSON_SNAK_TYPE_NOVALUE = "novalue";
    private final PropertyIdValue property;

    public SnakImpl(PropertyIdValue property) {
        Validate.notNull((Object)property);
        this.property = property;
    }

    protected SnakImpl(String id, String siteIri) {
        Validate.notNull((Object)id);
        Validate.notNull((Object)siteIri);
        this.property = new PropertyIdValueImpl(id, siteIri);
    }

    @JsonProperty(value="property")
    public String getProperty() {
        return this.property.getId();
    }

    @Override
    @JsonIgnore
    public PropertyIdValue getPropertyId() {
        return this.property;
    }

    @Override
    @JsonIgnore
    public Value getValue() {
        return null;
    }

    @JsonProperty(value="snaktype")
    public abstract String getSnakType();
}

