/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;

public class StatementGroupImpl
extends AbstractList<Statement>
implements StatementGroup {
    private final List<Statement> statements;

    public StatementGroupImpl(List<Statement> statements) {
        Validate.notNull(statements, (String)"A non-null list of statements must be provided to create a statement group.", (Object[])new Object[0]);
        Validate.isTrue((!statements.isEmpty() ? 1 : 0) != 0, (String)"A non-empty list of statements must be provided to create a statement group.", (Object[])new Object[0]);
        EntityIdValue subject = statements.get(0).getSubject();
        PropertyIdValue property = statements.get(0).getMainSnak().getPropertyId();
        for (Statement statement : statements) {
            Validate.isTrue((boolean)statement.getSubject().equals(subject), (String)"All statements of a statement group must have the same subject.", (Object[])new Object[0]);
            Validate.isTrue((boolean)statement.getMainSnak().getPropertyId().equals(property), (String)"All statements of a statement group must have the same subject.", (Object[])new Object[0]);
        }
        this.statements = statements;
    }

    @Override
    public Statement get(int i) {
        return this.statements.get(i);
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.statements.iterator();
    }

    @Override
    public int size() {
        return this.statements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    public List<Statement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    @Override
    public StatementGroup getBestStatements() {
        StatementRank bestRank = StatementRank.NORMAL;
        ArrayList<Statement> bestStatements = new ArrayList<Statement>();
        for (Statement statement : this.statements) {
            if (statement.getRank() == StatementRank.PREFERRED && bestRank == StatementRank.NORMAL) {
                bestRank = StatementRank.PREFERRED;
                bestStatements.clear();
            }
            if (statement.getRank() != bestRank) continue;
            bestStatements.add(statement);
        }
        return new StatementGroupImpl(bestStatements);
    }

    @Override
    public PropertyIdValue getProperty() {
        return this.statements.get(0).getMainSnak().getPropertyId();
    }

    @Override
    public EntityIdValue getSubject() {
        return this.statements.get(0).getSubject();
    }

    @Override
    public int hashCode() {
        return Hash.hashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.equalsStatementGroup(this, obj);
    }

    @Override
    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public StatementGroup withStatement(Statement statement) {
        String statementId = statement.getStatementId();
        boolean statementAdded = false;
        ArrayList<Statement> newStatements = new ArrayList<Statement>(this.statements);
        if (!statementId.isEmpty()) {
            for (int i = 0; i != newStatements.size(); ++i) {
                String currentStatementId = ((Statement)newStatements.get(i)).getStatementId();
                if (!currentStatementId.equals(statementId)) continue;
                newStatements.set(i, statement);
                statementAdded = true;
            }
        }
        if (!statementAdded) {
            newStatements.add(statement);
        }
        return new StatementGroupImpl(newStatements);
    }
}

